jQuery(document).ready(function ($) {
    // زمانی که روی دایو "add" کلیک می‌شود
    $('.add').on('click', function (e) {
        e.preventDefault();

        var productId = $(this).data('product-id'); // گرفتن ID محصول

        if (!productId) return; // اگر ID محصولی نبود

        // درخواست AJAX برای افزودن به سبد خرید
        $.ajax({
            url: wc_add_to_cart_params.ajax_url, // آدرس AJAX ووکامرس
            type: 'POST',
            data: {
                action: 'add_to_cart', // اکشن مربوط به اضافه کردن به سبد خرید
                product_id: productId,
            },
            success: function (response) {
                if (response.error && response.product_url) {
                    // اگر محصول متغیر است و نیاز به انتخاب نوع دارد
                    window.location.href = response.product_url; // انتقال به صفحه محصول
                } else {
                    Swal.fire({
                        title: 'تبریک میگم!',
                        text: 'محصول به سبد خرید شما افزوده شد.',
                        icon: 'success',
                        confirmButtonText: 'باشه'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // بروزرسانی تعداد سبد خرید با استفاده از AJAX
                            $(document.body).trigger('added_to_cart', [response.fragments, response.cart_hash]);
                            
                            // درخواست AJAX برای دریافت تعداد محصولات در سبد خرید
                            $.ajax({
                                url: wc_add_to_cart_params.ajax_url,
                                type: 'POST',
                                data: {
                                    action: 'get_cart_count', // اکشن مربوط به دریافت تعداد محصولات سبد خرید
                                },
                                success: function (cart_response) {
                                    if (cart_response.success) {
                                        // بروزرسانی تعداد محصولات در سبد خرید
                                        $('.cart-count').text(cart_response.data);
                                    }
                                }
                            });
                        }
                    });
                }
            }
        });
    });







    ////slider range
    $(".catRange").slider({
        id: "slider5b",
        min: 50000,
        max: 5000000,
        range: true,
        step: 50000,
        value: [50000, 5000000],
        rtl: 'false',
        formatter: function formatter(val) {
            if (Array.isArray(val)) {
                // به‌روزرسانی مقادیر min و max در ورودی‌های hidden
                $('#min_price').val(val[0]);
                $('#max_price').val(val[1]);
                return val[0] + " تومان " + "  تا   " + val[1] + " تومان ";
            } else {
                return val;
            }
        },
    });
    ////End slider range
});



jQuery(document).ready(function($) {
    // انتخاب دایوی با کلاس .compare.button
    $('.compare.button').each(function() {
        // افزودن کلاس bi bi-heart
        $(this).addClass('bi bi-arrow-left-right');

        // حذف متن داخل دایو
        $(this).contents().filter(function() {
            return this.nodeType === 3; // فیلتر کردن فقط متن‌ها (نود نوع 3)
        }).remove();
    });
});

///////wishlist
jQuery(function($) {
    //adding to favorite
    $('body').on('click', '.add-favorite', function () {
        var post_id = $(this).data('post_id');
        $.ajax({
            url: "/wp-admin/admin-ajax.php",
            type: 'POST',
            data: {
                'action': 'favorite',
                'post_id': post_id,
            },
            success: function (data) {
                $('.fv_' + post_id).html('<span data-post_id="' + post_id + '" class="delete-favorite icon-Save-fill"><i class="bi bi-heart-fill"></i></span>');
                $('.num-favorite').html(data);
            },
        });
    });
    //deleting from favorite
    $('body').on('click', '.delete-favorite', function () {
        var post_id = $(this).data('post_id');
        $.ajax({
            url: "/wp-admin/admin-ajax.php",
            type: 'POST',
            data: {
                'action': 'delfavorite',
                'post_id': post_id,
            },
            success: function (data) {
                $('.fv_' + post_id).html('<span data-post_id="' + post_id + '" class="add-favorite icon-Save"><i class="bi bi-heart"></i></span>');
                $('.num-favorite').html(data);
            },
        });
    });
});
////////// End wishlist ////////











/////
// Start Stories
////
jQuery(document).ready(function($) {
    // اسلایدر اصلی استوری‌ها
    var storiesSlider = new Swiper('.stories-slider', {
        slidesPerView: 12,
        spaceBetween: 15,
        loop: true, // فعال کردن حالت حلقه‌ای
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        autoplay: {
            delay: 4000,
            disableOnInteraction: false,
        },
        breakpoints: {
            320: {
                slidesPerView: 4,
                spaceBetween: 7,
            },
            768: {
                slidesPerView: 7,
                spaceBetween: 10,
            },
            1024: {
                slidesPerView: 12,
                spaceBetween: 15,
            },
        }
    });


    // اسلایدر مودال
    var modalSwiper;

    // باز کردن مودال و نمایش تصاویر مربوط به هر استوری
    $('.story-image').on('click', function() {
        // ایندکس استوری کلیک‌شده را می‌گیریم
        var index = $(this).data('story-index');
        var storyImages = $('.story-gallery-' + index).html(); // دریافت تصاویر مربوط به استوری کلیک‌شده

        // جایگزینی محتوای مودال با تصاویر گالری استوری کلیک‌شده
        $('#story-modal .swiper-wrapper').html(storyImages);

        // مودال را باز می‌کنیم
        $.magnificPopup.open({
            items: {
                src: '#story-modal',
                type: 'inline'
            },
            callbacks: {
                open: function() {
                    // اسلایدر مودال را ایجاد یا بازسازی می‌کنیم
                    if (!modalSwiper) {
                        modalSwiper = new Swiper('.modal-swiper', {
                            slidesPerView: 1,
                            spaceBetween: 10,
                            navigation: {
                                nextEl: '.swiper-button-next',
                                prevEl: '.swiper-button-prev',
                            },
                            autoplay: {
                                delay: 4000, // جابجایی خودکار هر 4 ثانیه
                                disableOnInteraction: false,
                            },
                            on: {
                                slideChange: handleProgressBar, // تنظیم هندلر برای تغییر اسلاید
                            },
                        });
                    } else {
                        modalSwiper.update(); // آپدیت کردن اسلایدر مودال برای بازسازی اسلایدها
                        modalSwiper.autoplay.start(); // شروع مجدد جابجایی خودکار
                    }
                    startProgressBar(modalSwiper); // شروع نوار پیشرفت برای اسلاید اول
                },
                close: function() {
                    // توقف جابجایی خودکار و نوار پیشرفت هنگام بستن مودال
                    modalSwiper.autoplay.stop();
                    resetProgressBars();
                }
            }
        });
    });

    // تابع شروع نوار پیشرفت برای اسلاید فعلی
    function startProgressBar(swiper) {
        var currentSlide = swiper.slides[swiper.activeIndex];
        var progressBar = $(currentSlide).find('.progress');

        // ریست کردن همه نوارهای پیشرفت
        resetProgressBars();

        // نمایش نوار پیشرفت برای اسلاید فعلی
        progressBar.closest('.progress-bar').css('display', 'block');

        // شروع نوار پیشرفت برای اسلاید فعلی
        setTimeout(function() {
            progressBar.css('width', '100%');
        }, 100); // تأخیر برای انیمیشن
    }

    // تابع ریست نوارهای پیشرفت
    function resetProgressBars() {
        $('.modal-swiper .swiper-slide .progress-bar').css('display', 'none');
        $('.modal-swiper .swiper-slide .progress').css('width', '0');
    }

    // هندلر تغییر اسلاید برای اجرای نوار پیشرفت اسلاید جدید
    function handleProgressBar() {
        resetProgressBars(); // ریست کردن همه نوارها
        startProgressBar(this); // شروع نوار پیشرفت برای اسلاید جدید
    }
});
/////
// End Stories
////


/////
//  cama banner
////
new Swiper('.cama-banner-slider', {
    loop: true,
    autoplay: {
        delay: 5000,
        disableOnInteraction: false,
    },
    pagination: {
        el: '.swiper-pagination',
        clickable: true,
    },
    navigation: {
        nextEl: '.swiper-button-next-banner-cama',
        prevEl: '.swiper-button-prev-banner-cama',
    },
});
/////
//  End cama banner
////

/////
//  cama banner
////
new Swiper('.cama-animated-slider-wrapper', {
    loop: true,
    autoplay: {
        delay: 5000,
        disableOnInteraction: false,
    },
    pagination: {
        el: '.swiper-pagination',
        clickable: true,
    },
    navigation: {
        nextEl: '.swiper-button-next',
        prevEl: '.swiper-button-prev',
    },
});
/////
//  End cama banner
////





/////
// start selected products special slider
////
jQuery(document).ready(function ($) {
    class Countdown {
        constructor(el) {
            this.el = el;
            this.targetDate = new Date(el.getAttribute("date-time"));

            this.createCountDownParts()
            this.countdownFunction();
            this.countdownLoopId = setInterval(this.countdownFunction.bind(this), 1000)
        }

        createCountDownParts() {
            ["days", "hours", "minutes", "seconds"].forEach(part => {
                const partEl = document.createElement("div");
                partEl.classList.add("part", part);
                const textEl = document.createElement("div");
                textEl.classList.add("text");
                textEl.innerText = ":";
                const numberEl = document.createElement("div");
                numberEl.classList.add("number");
                numberEl.innerText = 0;
                partEl.append(numberEl, textEl);
                this.el.append(partEl);
                this[part] = numberEl;
            })
        }

        countdownFunction() {
            const currentDate = new Date();
            if (currentDate > this.targetDate) return clearInterval(this.intervalId);
            const remaining = this.getRemaining(this.targetDate, currentDate);
            Object.entries(remaining).forEach(([part, value]) => {
                this[part].style.setProperty("--value", value)
                this[part].innerText = value
            })
        }

        getRemaining(target, now) {
            let seconds = Math.floor((target - (now)) / 1000);
            let minutes = Math.floor(seconds / 60);
            let hours = Math.floor(minutes / 60);
            let days = Math.floor(hours / 24);
            hours = hours - (days * 24);
            minutes = minutes - (days * 24 * 60) - (hours * 60);
            seconds = seconds - (days * 24 * 60 * 60) - (hours * 60 * 60) - (minutes * 60);
            return {days, hours, minutes, seconds}
        }

    }

    const countdownEls = document.querySelectorAll(".countdown") || [];


    countdownEls.forEach(countdownEl => new Countdown(countdownEl));


    var swiper = new Swiper(".prodcut-box-one-slider", {
        slidesPerView: 6,
        spaceBetween: 10,
        slidesPerGroup: 1,
        loop: true,
        loopFillGroupWithBlank: true,
        autoplay: {
            enabled: true,
            delay: 2000,
            disableOnInteraction: false,
        },
        speed: 500,
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
        breakpoints: {
            // when window width is >= 320px
            220: {
                slidesPerView: 1,
                spaceBetween: 20
            },
            // when window width is >= 480px
            480: {
                slidesPerView: 2,
                spaceBetween: 20
            },
            // when window width is >= 640px
            768: {
                slidesPerView: 3,
                spaceBetween: 20
            },
            1000: {
                slidesPerView: 6,
                spaceBetween: 20
            }
        },
    });
});


// برای لایک و دیسلایک بلاگ
jQuery(document).ready(function($) {
    $('#like-button').on('click', function() {
        var button = $(this);
        var postID = button.data('post-id');
        var isLiked = button.data('liked') === 'yes';

        $.ajax({
            url: like_post_params.ajaxurl,
            type: 'POST',
            data: {
                action: 'toggle_like',
                post_id: postID,
                liked: isLiked ? 1 : 0
            },
            success: function(response) {
                if (response.success) {
                    var newLikeCount = response.data.likes_count;
                    
                    // به‌روزرسانی مقدار نمایش لایک‌ها بدون رفرش صفحه
                    $('.text-muted.badge').text(newLikeCount + ' نفر این پست را پسندیدند');

                    // تغییر مقدار data-liked و متن دکمه
                    if (isLiked) {
                        button.data('liked', 'no').html('پسندیدم <i class="fas fa-heart"></i>');
                    } else {
                        button.data('liked', 'yes').html('نمی‌پسندم! <i class="fas fa-heart-broken"></i>');
                    }
                } else {
                    Swal.fire({
                        title: 'خطایی رخ داده است!',
                        text: 'لطفا مجددا تلاش کنید.',
                        icon: 'error',
                        confirmButtonText: 'باشه'
                    });
                }
            }
        });
    });
});


// پایان لایک و دیسلایک بلاگ













