<?php
/**
 * Plugin Name: اددان های اختصاصی المنتور کاما
 * Description: پلاگین اختصاصی کاما برای المنتور
 * Version:     1.2.2
 * Author:      مرتضی جلادت
 * Author URI:  https://cama.viramoon.ir/
 * Text Domain: elementor-addon
 */

define( 'Cama_PLG_PATH', trailingslashit( plugin_dir_path(__FILE__) ) );
define( 'Cama_PLG_URI', trailingslashit( plugin_dir_url(__FILE__) ) );
define( 'Cama_CSS_URI', trailingslashit( Cama_PLG_URI . 'assets/css' ) );
define( 'Cama_JS_URI', trailingslashit( Cama_PLG_URI . 'assets/js' ) );

define('Cama_THEME_VERSION' , '1.2.2');

include Cama_PLG_PATH.'inc/function.php';
include Cama_PLG_PATH.'inc/product-box.php';
include Cama_PLG_PATH.'inc/wishlist.php';
include Cama_PLG_PATH.'inc/dashboard.php';
include Cama_PLG_PATH.'inc/license.php';

function register_cama_manage_widgets( $widgets_manager ) {
    require_once( __DIR__ . '/widgets/main-slider.php' );
    require_once( __DIR__ . '/widgets/amazing-products.php' );
    require_once(__DIR__ . '/widgets/features-area.php');
    require_once(__DIR__ . '/widgets/banners.php');
    require_once(__DIR__ . '/widgets/offer-amazing-products.php');
    require_once( __DIR__ . '/widgets/categories.php' );
    require_once(__DIR__ . '/widgets/new-products.php');
    require_once(__DIR__ . '/widgets/most-sales-products.php');
    require_once( __DIR__ . '/widgets/selected-products.php' );
    require_once( __DIR__ . '/widgets/blog-slider.php' );
    require_once( __DIR__ . '/widgets/special-contents.php' );
    require_once( __DIR__ . '/widgets/stories.php' );
    require_once( __DIR__ . '/widgets/cama-banner.php' );
    require_once( __DIR__ . '/widgets/selected-products-special-slider.php' );
    require_once( __DIR__ . '/widgets/fixed-background-banner.php' );
    require_once( __DIR__ . '/widgets/random-products.php' );
    require_once( __DIR__ . '/widgets/animated-slider.php' );
    // require_once( __DIR__ . '/widgets/brands-area.php' );

    $widgets_manager->register( new \Main_Slider_Widget() );
    $widgets_manager->register( new \Amazing_Products_Widget() );
    $widgets_manager->register( new \Features_Area_Widget());
    $widgets_manager->register( new \Banners_Widget() );
    $widgets_manager->register( new \Offer_Amazing_Products_Widget() );
    $widgets_manager->register( new \Categories_Widget() );
    $widgets_manager->register( new \New_Products_Widget() );
    $widgets_manager->register( new \Most_Sales_Widget() );
    $widgets_manager->register( new \Selected_Products_Widget() );
    $widgets_manager->register( new \Blog_Slider_Widget() );
    $widgets_manager->register( new \Special_Contents_Widget() );
    $widgets_manager->register( new \Stories_Widget() );
    $widgets_manager->register( new \Cama_Banner_Widget() );
    $widgets_manager->register( new \Selected_Products_special_slider_widget() );
    $widgets_manager->register( new \Fixed_background_Banner_Widget() );
    $widgets_manager->register( new \Random_Products_Widget() );
    $widgets_manager->register( new \Animated_Slider_Widget() );
    // $widgets_manager->register( new \Brands_Area_Widget() );
}
add_action( 'elementor/widgets/register', 'register_cama_manage_widgets' );



function load_jquery_ui() {
    wp_enqueue_script('jquery-ui-core');
    wp_enqueue_script('jquery-ui-widget');
    wp_enqueue_script('jquery-ui-autocomplete');
}
add_action('wp_enqueue_scripts', 'load_jquery_ui');



//assets links
add_action('wp_enqueue_scripts', 'cama_name_scripts');
function cama_name_scripts()
{
    //    CSS Styles
//    wp_enqueue_style('503', plugin_dir_url( __FILE__ ) . 'assets/plugin/503/style.css');
    wp_enqueue_style('bootstrap-rtl', plugin_dir_url( __FILE__ ) . 'assets/css/bootstrap.rtl.min.css');
    wp_enqueue_style('responsive', plugin_dir_url( __FILE__ ) . 'assets/css/responsive.css');
    wp_enqueue_style('bootstrap-slider', plugin_dir_url( __FILE__ ) . 'assets/plugin/bootstrap-slider/bootstrap-slider.min.css');
    wp_enqueue_style('bootstrap-touchspin', plugin_dir_url( __FILE__ ) . 'assets/plugin/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css');
    wp_enqueue_style('go-to-top', plugin_dir_url( __FILE__ ) . 'assets/plugin/go-to-top/style.css');
    wp_enqueue_style('hint-css', plugin_dir_url( __FILE__ ) . 'assets/plugin/hint-css/hint-css.css');
    wp_enqueue_style('owl.carousel', plugin_dir_url( __FILE__ ) . 'assets/plugin/owl.carousel/owl.carousel.min.css');
    wp_enqueue_style('rasta-contact', plugin_dir_url( __FILE__ ) . 'assets/plugin/rasta-contact/style.css');
    wp_enqueue_style('select2', plugin_dir_url( __FILE__ ) . 'assets/css/select2.min.css');
    wp_enqueue_style('swiper', plugin_dir_url( __FILE__ ) . 'assets/plugin/swiper/swiper-bundle.min.css');
    wp_enqueue_style('tagify', plugin_dir_url( __FILE__ ) . 'assets/plugin/tagify/tagify.css');
    wp_enqueue_style('tagit', plugin_dir_url( __FILE__ ) . 'assets/plugin/tagit/jquery.tagit.css');
    wp_enqueue_style('timer', plugin_dir_url( __FILE__ ) . 'assets/plugin/timer/timer.css');
    wp_enqueue_style('waves', plugin_dir_url( __FILE__ ) . 'assets/plugin/waves/waves.min.css');
    wp_enqueue_style('fontawesome-all', plugin_dir_url( __FILE__ ) . 'assets/plugin/font-awesome/css/all.css');
    wp_enqueue_style('magnific-popup', plugin_dir_url( __FILE__ ) . 'assets/plugin/magnific/magnific-popup.min.css');
    wp_enqueue_style('bootstrap-icon', plugin_dir_url( __FILE__ ) . 'assets/font/bootstrap-icon/bootstrap-icons.css');
    wp_enqueue_style('style', plugin_dir_url( __FILE__ ) . 'assets/css/style.css');


    //  End CSS Styles

    //    Scripts
    wp_enqueue_script('swiper', plugin_dir_url(__FILE__) . 'assets/plugin/swiper/swiper-bundle.min.js', array('jquery'), '', true);
    wp_enqueue_script('app', plugin_dir_url(__FILE__) . 'assets/js/app.js', array('jquery'), '', true);
    wp_enqueue_script('bootstrap', plugin_dir_url(__FILE__) . 'assets/js/bootstrap.bundle.min.js', array('jquery'), '', true);
    wp_enqueue_script('jquery', plugin_dir_url(__FILE__) . 'assets/js/jquery.min.js', array('jquery'), '', true);
    wp_enqueue_script('jquery-app', plugin_dir_url(__FILE__) . 'assets/js/jquery-app.js', array('jquery'), '', true);
//    wp_enqueue_script('503', plugin_dir_url(__FILE__) . 'assets/plugin/503/script.js', array('jquery'), '', true);
    wp_enqueue_script('bootstrap-slider', plugin_dir_url(__FILE__) . 'assets/plugin/bootstrap-slider/bootstrap-slider.min.js', array('jquery'), '', true);
    wp_enqueue_script('bootstrap-touchspin', plugin_dir_url(__FILE__) . 'assets/plugin/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js', array('jquery'), '', true);
    wp_enqueue_script('chartjs', plugin_dir_url(__FILE__) . 'assets/plugin/chartjs/chart.js', array('jquery'), '', true);
    wp_enqueue_script('go-to-top', plugin_dir_url(__FILE__) . 'assets/plugin/go-to-top/script.js', array('jquery'), '', true);
    wp_enqueue_script('hint-css', plugin_dir_url(__FILE__) . 'assets/plugin/hint-css/hint-css.js', array('jquery'), '', true);
    wp_enqueue_script('owl.carousel', plugin_dir_url(__FILE__) . 'assets/plugin/owl.carousel/owl.carousel.min.js', array('jquery'), '', true);
    wp_enqueue_script('rasta-contact', plugin_dir_url(__FILE__) . 'assets/plugin/rasta-contact/script.js', array('jquery'), '', true);
    wp_enqueue_script('select2', plugin_dir_url(__FILE__) . 'assets/js/select2.min.js', array('jquery'), '', true);
    wp_enqueue_script('tagify', plugin_dir_url(__FILE__) . 'assets/plugin/tagify/jQuery.tagify.min.js', array('jquery'), '', true);
    wp_enqueue_script('sweetalert', plugin_dir_url(__FILE__) . 'assets/plugin/sweetalert/sweetalert.js', array('jquery'), '', true);
    wp_enqueue_script('tagit', plugin_dir_url(__FILE__) . 'assets/plugin/tagit/tag-it.min.js', array('jquery'), '', true);
    wp_enqueue_script('timer', plugin_dir_url(__FILE__) . 'assets/plugin/timer/timer.js', array('jquery'), '', true);
    wp_enqueue_script('typed', plugin_dir_url(__FILE__) . 'assets/plugin/typed/typed.min.js', array('jquery'), '', true);
    wp_enqueue_script('waves', plugin_dir_url(__FILE__) . 'assets/plugin/waves/waves.min.js', array('jquery'), '', true);
    wp_enqueue_script('fontawesome', plugin_dir_url(__FILE__) . 'assets/plugin/font-awesome/js/all.js', array('jquery'), '', true);
    wp_enqueue_script('magnific-popup', plugin_dir_url(__FILE__) . 'assets/plugin/magnific/magnific-popup.min.js', array('jquery'), '', true);
    wp_enqueue_script('custom', plugin_dir_url(__FILE__) . 'assets/js/custom.js', array('jquery'), '', true);

    //    End Scripts
}

// add category to elementor
function add_elementor_widget_categories( $elements_manager ) {

    $elements_manager->add_category(
        'cama_category',
        [
            'title' => 'ویجت های اختصاصی کاما',
            'icon' => 'fa fa-plug',
        ]
    );

}
add_action( 'elementor/elements/categories_registered', 'add_elementor_widget_categories' );
// End add category to elementor

