
<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @see get_the_archive_title()
 *
 * @package cama
 */

get_header();
?>

<!-- bread crumb -->
<div class="content">
    <div class="container-fluid">
        <nav aria-label="breadcrumb" class="my-lg-0 my-2">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?php echo home_url(); ?>" class="font-14 text-muted">خانه</a></li>
                <?php if (is_category()) : ?>
                    <li class="breadcrumb-item active main-color-one-color font-14" aria-current="page"><?php single_cat_title(); ?></li>
                <?php elseif (is_tag()) : ?>
                    <li class="breadcrumb-item active main-color-one-color font-14" aria-current="page"><?php single_tag_title(); ?></li>
                <?php elseif (is_author()) : ?>
                    <li class="breadcrumb-item active main-color-one-color font-14" aria-current="page">نوشته‌های <?php the_author(); ?></li>
                <?php elseif (is_date()) : ?>
                    <li class="breadcrumb-item active main-color-one-color font-14" aria-current="page"><?php echo get_the_date(); ?></li>
                <?php elseif (is_archive()) : ?>
                    <li class="breadcrumb-item active main-color-one-color font-14" aria-current="page">آرشیو</li>
                <?php endif; ?>
            </ol>
        </nav>
    </div>
</div>


<main id="primary" class="site-main">
    <?php if ( have_posts() ) { ?>

                 <!-- start main-data -->
        <div class="content">
            <div class="container-fluid">
                <div class="row gy-2">
                    <div class="col-lg-3 order-lg-1 order-2">
                        <div class="item-boxs">
<!--                            <div class="item-box bg-white shadow-box">-->
<!--                                <div class="title">-->
<!--                                    <div class="d-flex align-items-center justify-content-between">-->
<!--                                        <h6 class="font-14">جستجو</h6>-->
<!--                                        <a class="btn border-0" data-bs-toggle="collapse" href="#collapseItemBoxSearch"-->
<!--                                           role="button" aria-expanded="false">-->
<!--                                            <i class="bi bi-chevron-down"></i>-->
<!--                                        </a>-->
<!--                                    </div>-->
<!--                                </div>-->
<!--                                <div class="desc collapse show" id="collapseItemBoxSearch">-->
<!--                                    <form action="--><?php //echo site_url('/search-post/'); ?><!--" method="get">-->
<!--                                        <div class="position-relative">-->
<!--                                            <input type="text" name="s" class="form-control font-14 rounded-pill text-muted py-3 border-muted bg-light"-->
<!--                                                   placeholder="نام وبلاگ مورد نظر خود را وارد کنید" value="--><?php //echo get_search_query(); ?><!--">-->
<!--                                            <button type="submit" class="position-absolute top-50 translate-middle-y btn rounded-circle border-0"-->
<!--                                                    style="left: 5px;">-->
<!--                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-search"-->
<!--                                                     viewBox="0 0 16 16">-->
<!--                                                    <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>-->
<!--                                                </svg>-->
<!--                                            </button>-->
<!--                                        </div>-->
<!--                                    </form>-->
<!---->
<!--                                </div>-->
<!--                            </div>-->
                            <div class="item-box bg-white shadow-box">
                                <div class="title">
                                    <h6 class="font-14">دسته بندی ها</h6>
                                </div>
                                <div class="desc">
                                    <?php
                                    // گرفتن دسته‌بندی‌هایی که حداقل یک مطلب دارند
                                    $categories = get_categories(array(
                                        'hide_empty' => true, // دسته‌هایی که مطالبی ندارند را حذف می‌کند
                                    ));
                                    foreach ($categories as $category) {
                                        ?>
                                        <a href="<?php echo get_category_link($category->term_id); ?>">
                                            <div class="d-flex align-items-center justify-content-between flex-wrap mb-3">
                                                <div class="d-flex align-items-center">
                                                    <div class="box-icon"><i class="bi bi-tag"></i></div>
                                                    <span><?php echo $category->name; ?></span>
                                                </div>
                                                <div>
                                                    <span class="fw-bold font-16">(<?php echo $category->count; ?>)</span>
                                                </div>
                                            </div>
                                        </a>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                            <div class="item-box bg-white shadow-box">
                                <div class="title">
                                    <h6 class="font-14">برچسب ها</h6>
                                </div>
                                <div class="desc">
                                    <div class="d-flex align-items-center flex-wrap">
                                        <?php
                                        // گرفتن تمام برچسب‌ها
                                        $tags = get_tags();
                                        foreach ($tags as $tag) {
                                            ?>
                                            <div class="blog-tag">
                                                <a href="<?php echo get_tag_link($tag->term_id); ?>"><?php echo $tag->name; ?></a>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-9 order-lg-2 order-1">
                        <div class="content-box">
                            <div class="row gy-4">
                                <?php if ( have_posts() ) : ?>
                                    <?php while ( have_posts() ) : the_post(); ?>
                                        <div class="col-md-4 col-sm-6">
                                            <div class="shadow-box">
                                                <div class="card shadow-inner border-muted">
                                                    <!-- تصویر شاخص پست -->
                                                    <div class="image-blog text-center">
                                                        <?php if ( has_post_thumbnail() ) : ?>
                                                            <img src="<?php the_post_thumbnail_url('medium'); ?>" class="img-fluid rounded-2" alt="<?php the_title(); ?>">
                                                        <?php else : ?>
                                                            <img src="<?php echo get_template_directory_uri(); ?>/assets/image/mobile.png" class="img-fluid rounded-2" alt="Default Image">
                                                        <?php endif; ?>
                                                        <div class="blog-desc p-0 px-2 position-absolute bottom-0">
                                                            <div class="d-flex justify-content-between align-items-center my-2">
                                                                <div class="like">
                                                                    <span class="icon">
                                                                        <i class="bi bi-heart"></i>
                                                                    </span>
                                                                    <span class="counter font-12"><?php echo get_post_meta(get_the_ID(), 'likes_count', true) ?: 0; ?></span>
                                                                </div>
                                                                <div class="date">
                                                                        <span class="icon">
                                                                            <i class="bi bi-calendar-event"></i>
                                                                        </span>
                                                                    <span class="font-12"><?php echo human_time_diff( get_the_time('U'), current_time('timestamp') ) . ' پیش'; ?></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- محتویات کارت پست -->
                                                    <div class="card-body">
                                                        <h5 class="card-title h5 text-overflow-2"><?php the_title(); ?></h5>
                                                        <p class="card-text text-overflow-3 font-14 text-justify lh-lg mt-3"><?php echo wp_trim_words( get_the_excerpt(), 20, '...' ); ?></p>
                                                        <a href="<?php the_permalink(); ?>" class="span-primary rounded-3 font-14 shadow-md">مشاهده</a>
                                                        <div class="my-card-footer mt-3 d-flex justify-content-center border-top pt-2 border-muted">
                                                            <div class="btn-group" role="group">
                                                                <!-- دسته بندی پست -->
                                                                <?php
                                                                $category = get_the_category();
                                                                if ( ! empty( $category ) ) :
                                                                    ?>
                                                                    <a href="<?php echo esc_url( get_category_link( $category[0]->term_id ) ); ?>" class="btn border-0 bg-dark text-white btn-sm" style="border-top-right-radius:20px;border-bottom-right-radius:20px">
                                                                        <?php echo esc_html( $category[0]->name ); ?>
                                                                    </a>
                                                                <?php endif; ?>
                                                                <!-- تعداد دیدگاه‌ها -->
                                                                <a href="<?php comments_link(); ?>" class="btn border-0 bg-primary text-white btn-sm" style="border-top-left-radius:20px;border-bottom-left-radius:20px">
                                                                    <?php comments_number( '0 دیدگاه', '1 دیدگاه', '% دیدگاه' ); ?>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                <?php else : ?>
                                    <p>پستی یافت نشد.</p>
                                <?php endif; ?>
                            </div>
                            <div class="my-paginate my-4">
                                <?php
                                echo get_the_posts_pagination();
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end main-data -->

        <footer class="page-footer">
            <?php
            the_archive_description( '<div class="archive-description">', '</div>' );
            ?>
        </footer><!-- .page-header -->



        <?php
    }else {
        get_template_part('template-parts/content', 'none');
    }
    ?>
</main><!-- #main -->

<?php
get_footer();


