<?php
/*
Template Name: cart
Template Post Type: post, page
 */
?>
<?php get_header(); ?>

<?php
defined('ABSPATH') || exit;

do_action('woocommerce_before_cart');
?>

<div class="content">
    <div class="container-fluid">

        <div class="content-box">
            <div class="line-step-container d-sm-block d-none">
                <div class="line-step">
                    <div class="line-step-boxs">
                        <div class="line-step-box complete">
                            <a href="cart.html">
                                <div class="icon">
                                    <i class="bi bi-bag"></i>
                                </div>
                                <p>سبد خرید</p>
                            </a>
                        </div>
                        <div class="line-step-box disabled">
                            <a href="checkout.html">
                                <div class="icon">
                                    <i class="bi bi-file-earmark-text"></i>
                                </div>
                                <p>جزییات پرداخت</p>
                            </a>
                        </div>
                        <div class="line-step-box disabled">
                            <a href="cart.html">
                                <div class="icon">
                                    <i class="bi bi-file-earmark-break"></i>
                                </div>
                                <p>تکمیل سفارش</p>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row gx-5 align-items-center cart">
                <div class="col-lg-8 cart-table">
                    <div class="cart-detail">
                        <?php if (WC()->cart->is_empty()) : ?>
                            <div class="empty-cart text-center">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/image/emptycart.gif" alt="سبد خرید خالی است" style="max-width: 300px; margin: 0 auto;">
                                <h4 class="mt-3">سبد خرید شما خالی است</h4>
                                <a href="<?php echo esc_url(wc_get_page_permalink('shop')); ?>" class="btn main-color-one-bg mt-3">
                                    بازگشت به فروشگاه
                                </a>
                            </div>
                        <?php else : ?>
                        <div class="responsive-table">
                            <form class="woocommerce-cart-form" action="<?php echo esc_url(wc_get_cart_url()); ?>"
                                  method="post">
                                <?php do_action('woocommerce_before_cart_table'); ?>
                                <table class="table main-table table-borderless">
                                    <thead>
                                    <tr>
                                        <th><?php esc_html_e('حذف', 'woocommerce'); ?></th>
                                        <th><?php esc_html_e('تصویر', 'woocommerce'); ?></th>
                                        <th class="product-name"><?php esc_html_e('محصول', 'woocommerce'); ?></th>
                                        <th class="product-price"><?php esc_html_e('قیمت', 'woocommerce'); ?></th>
                                        <th class="product-quantity"><?php esc_html_e('تعداد', 'woocommerce'); ?></th>
                                        <th class="product-subtotal"><?php esc_html_e('قیمت کل', 'woocommerce'); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php do_action('woocommerce_before_cart_contents'); ?>

                                    <?php
                                    foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
                                        $_product = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
                                        $product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);

                                        if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_cart_item_visible', true, $cart_item, $cart_item_key)) {
                                            $product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
                                            ?>
                                            <tr class="woocommerce-cart-form__cart-item <?php echo esc_attr(apply_filters('woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key)); ?>">
                                                <td data-title="<?php esc_attr_e('حذف', 'woocommerce'); ?>">
                                                    <?php
                                                    echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                                        'woocommerce_cart_item_remove_link',
                                                        sprintf(
                                                            '<a href="%s" data-hint="حذف محصول از سبد خرید" class="hint--left remove" aria-label="%s" data-product_id="%s" data-product_sku="%s"><i class="bi bi-x-circle-fill"></i></a>',
                                                            esc_url(wc_get_cart_remove_url($cart_item_key)),
                                                            esc_html__('Remove this item', 'woocommerce'),
                                                            esc_attr($product_id),
                                                            esc_attr($_product->get_sku())
                                                        ),
                                                        $cart_item_key
                                                    );
                                                    ?>
                                                </td>
                                                <td class="product-thumbnail" data-title="<?php esc_attr_e('تصویر', 'woocommerce'); ?>">
                                                    <?php
                                                    $thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);

                                                    if (!$product_permalink) {
                                                        echo $thumbnail; // PHPCS: XSS ok.
                                                    } else {
                                                        printf('<a href="%s">%s</a>', esc_url($product_permalink), $thumbnail); // PHPCS: XSS ok.
                                                    }
                                                    ?>
                                                </td>

                                                <td class="title"
                                                    data-title="<?php esc_attr_e('Product', 'woocommerce'); ?>">
                                                    <?php
                                                    if (!$product_permalink) {
                                                        echo wp_kses_post(apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key) . '&nbsp;');
                                                    } else {
                                                        echo wp_kses_post(apply_filters('woocommerce_cart_item_name', sprintf('<a href="%s">%s</a>', esc_url($product_permalink), $_product->get_name()), $cart_item, $cart_item_key));
                                                    }

                                                    do_action('woocommerce_after_cart_item_name', $cart_item, $cart_item_key);

                                                    // Meta data.
                                                    echo wc_get_formatted_cart_item_data($cart_item); // PHPCS: XSS ok.

                                                    // Backorder notification.
                                                    if ($_product->backorders_require_notification() && $_product->is_on_backorder($cart_item['quantity'])) {
                                                        echo wp_kses_post(apply_filters('woocommerce_cart_item_backorder_notification', '<p class="backorder_notification">' . esc_html__('Available on backorder', 'woocommerce') . '</p>', $product_id));
                                                    }
                                                    ?>
                                                </td>
                                                <td class="product-price num"
                                                    data-title="<?php esc_attr_e('Price', 'woocommerce'); ?>">
                                                    <?php
                                                    echo apply_filters('woocommerce_cart_item_price', WC()->cart->get_product_price($_product), $cart_item, $cart_item_key); // PHPCS: XSS ok.
                                                    ?>
                                                </td>

                                                <td class="product-quantity counter"
                                                    data-title="<?php esc_attr_e('Quantity', 'woocommerce'); ?>">
                                                    <?php
                                                    if ($_product->is_sold_individually()) {
                                                        $min_quantity = 1;
                                                        $max_quantity = 1;
                                                    } else {
                                                        $min_quantity = 0;
                                                        $max_quantity = $_product->get_max_purchase_quantity();
                                                    }

                                                    $product_quantity = woocommerce_quantity_input(
                                                        array(
                                                            'input_name' => "cart[{$cart_item_key}][qty]",
                                                            'input_value' => $cart_item['quantity'],
                                                            'max_value' => $max_quantity,
                                                            'min_value' => $min_quantity,
                                                            'product_name' => $_product->get_name(),
                                                        ),
                                                        $_product,
                                                        false
                                                    );

                                                    echo apply_filters('woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item); // PHPCS: XSS ok.
                                                    ?>
                                                </td>

                                                <td class="product-subtotal num"
                                                    data-title="<?php esc_attr_e('Subtotal', 'woocommerce'); ?>">
                                                    <?php
                                                    echo apply_filters('woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal($_product, $cart_item['quantity']), $cart_item, $cart_item_key); // PHPCS: XSS ok.
                                                    ?>
                                                </td>
                                            </tr>
                                            <?php
                                        }
                                    }
                                    ?>
                                    <?php do_action('woocommerce_cart_contents'); ?>


                                    <tr class="cart-action mt-lg-0 mt-3">
                                        <div class="row flex-wrap align-items-center">

                                            <?php if (wc_coupons_enabled()) { ?>
                                            <td colspan="4">
                                                <div class="row g-2 align-items-center">
                                                    <div class="col-sm-6">
                                                        <input
                                                                type="text" name="coupon_code"
                                                                class="form-control rounded-pill" id="coupon_code"
                                                                value=""
                                                                placeholder="<?php esc_attr_e('Coupon code', 'woocommerce'); ?>"/>

                                                    </div>
                                                    <div class="col-sm-6">
                                                        <button type="submit"
                                                                class="btn btn-discount border-0 main-color-one-bg waves-effect waves-light rounded-pill font-14 button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>"
                                                                name="apply_coupon"
                                                                value="<?php esc_attr_e('Apply coupon', 'woocommerce'); ?>"><?php esc_attr_e('Apply coupon', 'woocommerce'); ?>
                                                            <i class="bi bi-plus"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <?php do_action('woocommerce_cart_coupon'); ?>
                                                <?php } ?>
                                            </td>
                                            <td colspan="2">
                                                    <div class="cart-footer-update text-sm-end text-center mt-sm-0 mt-3">
                                                        <button type="submit"
                                                                class="btn border-0 main-color-one-bg waves-effect waves-light rounded-pill font-14 button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>"
                                                                name="update_cart"
                                                                value="<?php esc_attr_e('Update cart', 'woocommerce'); ?>"><?php esc_html_e('Update cart', 'woocommerce'); ?>
                                                            <i class="bi bi-arrow-repeat ms-1"></i>
                                                        </button>
                                                    </div>
                                            </td>
                                                <?php do_action('woocommerce_cart_actions'); ?>

                                                <?php wp_nonce_field('woocommerce-cart', 'woocommerce-cart-nonce'); ?>

                                    </tr>

                                    <?php do_action('woocommerce_after_cart_contents'); ?>
                                    </tbody>
                                </table>
                                <?php do_action('woocommerce_after_cart_table'); ?>
                            </form>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>


                <div class="col-lg-4">
                    <div class="cart-payment mt-lg-0 mt-3">
                        <div class="title text-center">
                            <h4 class="slider-title fw-900 def-color mb-3">مجموع کل سبد خرید</h4>
                        </div>
                        <table class="table main-table text-center">
                            <tr>
                                <td class="fw-bold">قیمت کل</td>
                                <td>
                    <span class="fw-bold">
                        <?php echo WC()->cart->get_cart_subtotal(); // نمایش قیمت کل بدون هزینه‌های جانبی ?>
                    </span>
                                    <span class="text-muted font-10">تومان</span>
                                </td>
                            </tr>
                            <?php
                            // بررسی فعال بودن محاسبه‌گر حمل و نقل در تنظیمات
                            $enable_shipping_calc = get_option('woocommerce_enable_shipping_calc', 'no');
                            $shipping_total = 0;
                            if ($enable_shipping_calc === 'yes' && WC()->cart->needs_shipping() && WC()->cart->show_shipping()):
                                $shipping_total = WC()->cart->get_shipping_total();
                                ?>
                                <tr>
                                    <td class="fw-bold">هزینه ارسال</td>
                                    <td>
                        <span class="fw-bold">
                            <?php echo wc_price($shipping_total); // نمایش هزینه ارسال ?>
                        </span>
                                        <span class="text-muted font-10">تومان</span>
                                    </td>
                                </tr>
                            <?php endif; ?>
                            <tr>
                                <td class="fw-bold">مجموع</td>
                                <td>
                    <span class="fw-bold">
                        <?php
                        // محاسبه مجموع بدون در نظر گرفتن هزینه حمل و نقل در صورت غیرفعال بودن
                        if ($enable_shipping_calc === 'yes') {
                            echo WC()->cart->get_total(); // مجموع با هزینه ارسال
                        } else {
                            $total_without_shipping = WC()->cart->cart_contents_total + WC()->cart->get_taxes_total();
                            echo wc_price($total_without_shipping); // مجموع بدون هزینه ارسال
                        }
                        ?>
                    </span>
                                    <span class="text-muted font-10">تومان</span>
                                </td>
                            </tr>
                        </table>
                        <form action="<?php echo wc_get_checkout_url(); ?>" method="get">
                            <button class="btn mt-3 w-100 py-3 border-0 main-color-one-bg waves-effect waves-light">
                                اقدام به پرداخت
                                <i class="bi bi-bank2"></i>
                            </button>
                        </form>
                    </div>
                </div>




            </div>
        </div>
    </div>
</div>
<!-- end main-data -->





<?php get_footer(); ?>
