<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package ivan
 */

?>


<footer class="py-20 border-top border-4 border-muted shadow-box">
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-md-4 mt-md-0 mt-3">
                <h6 class="font-16 mb-2">آدرس و مشخصات</h6>
                <div class="d-flex my-2">
                        <span class="main-color-one-color">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                 class="bi bi-geo-alt" viewBox="0 0 16 16">
                                <path
                                        d="M12.166 8.94c-.524 1.062-1.234 2.12-1.96 3.07A31.493 31.493 0 0 1 8 14.58a31.481 31.481 0 0 1-2.206-2.57c-.726-.95-1.436-2.008-1.96-3.07C3.304 7.867 3 6.862 3 6a5 5 0 0 1 10 0c0 .862-.305 1.867-.834 2.94zM8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10z"/>
                                <path d="M8 8a2 2 0 1 1 0-4 2 2 0 0 1 0 4zm0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6z"/>
                            </svg>
                        </span>
                    <span class="ms-3 font-14 text-muted">
                            <?php echo esc_html(get_theme_mod('footer_address_setting', '')); ?>
                        </span>
                </div>
                <div class="d-flex flex-direction-column justify-content-between flex-wrap">
                    <div class="d-flex my-2">
                            <span class="main-color-one-color">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                     class="bi bi-phone" viewBox="0 0 16 16">
                                    <path
                                            d="M11 1a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h6zM5 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H5z"/>
                                    <path d="M8 14a1 1 0 1 0 0-2 1 1 0 0 0 0 2z"/>
                                </svg>
                            </span>
                        <span class="ms-3 font-16 main-color-one-color text-muted fw-bold">
                                <a href="tel:<?php echo esc_html(get_theme_mod('phone_number', '')); ?>"><?php echo esc_html(get_theme_mod('phone_number', '')); ?></a>
                            </span>
                    </div>
                    <div class="d-flex my-2">
                            <span class="main-color-one-color">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                     class="bi bi-envelope" viewBox="0 0 16 16">
                                    <path
                                            d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V4Zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1H2Zm13 2.383-4.708 2.825L15 11.105V5.383Zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741ZM1 11.105l4.708-2.897L1 5.383v5.722Z"/>
                                </svg>
                            </span>
                        <span class="ms-3 font-14 text-muted">
                                <?php echo esc_html(get_theme_mod('footer_email_setting', '')); ?>
                            </span>
                    </div>
                </div>
            </div>
            <div class="col-md-2 col-6 mt-md-0 mt-3">
                <?php
                $menu_name = wp_get_nav_menu_name('footer-menu1'); // دریافت نام فهرست جایگاه
                if ($menu_name) {
                    ?>

                    <h6 class="font-16 mb-2">
                        <?php echo esc_html($menu_name) ?>
                    </h6>

                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'footer-menu1',
                        'container' => 'ul', // برچسب مورد نظر برای لیست
                        'menu_class' => 'navbar-nav flex-column', // کلاس‌های CSS برای ul
                        'link_class' => 'nav-link font-14', // کلاس CSS برای لینک‌ها
                        'item_class' => 'nav-item', // کلاس CSS برای هر li
                        'fallback_cb' => false // اگر منو تنظیم نشده باشد چیزی نمایش ندهد
                    ));
                    ?>

                    <?php
                }
                ?>
            </div>
            <div class="col-md-2 col-6 mt-md-0 mt-3">
                <?php
                $menu_name = wp_get_nav_menu_name('footer-menu2'); // دریافت نام فهرست جایگاه
                if ($menu_name) {
                    ?>

                    <h6 class="font-16 mb-2">
                        <?php echo esc_html($menu_name) ?>
                    </h6>
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'footer-menu2',
                        'container' => 'ul', // برچسب مورد نظر برای لیست
                        'menu_class' => 'navbar-nav flex-column', // کلاس‌های CSS برای ul
                        'link_class' => 'nav-link font-14', // کلاس CSS برای لینک‌ها
                        'item_class' => 'nav-item', // کلاس CSS برای هر li
                        'fallback_cb' => false // اگر منو تنظیم نشده باشد چیزی نمایش ندهد
                    ));
                    ?>

                    <?php
                }
                ?>
            </div>
            <div class="col-md-2 col-6 mt-md-0 mt-3">
                <?php
                $menu_name = wp_get_nav_menu_name('footer-menu3'); // دریافت نام فهرست جایگاه
                if ($menu_name) {
                    ?>

                    <h6 class="font-16 mb-2">
                        <?php echo esc_html($menu_name) ?>
                    </h6>
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'footer-menu3',
                        'container' => 'ul', // برچسب مورد نظر برای لیست
                        'menu_class' => 'navbar-nav flex-column', // کلاس‌های CSS برای ul
                        'link_class' => 'nav-link font-14', // کلاس CSS برای لینک‌ها
                        'item_class' => 'nav-item', // کلاس CSS برای هر li
                        'fallback_cb' => false // اگر منو تنظیم نشده باشد چیزی نمایش ندهد
                    ));
                    ?>

                    <?php
                }
                ?>
            </div>
            <div class="col-md-2 mt-md-5 mt-2 col-6">
                <div class="small-slider nemads">
                    <div class="swiper swiper-small-slider">
                        <div class="swiper-wrapper">
                            <?php
                            $footer_texts = get_theme_mod('footer_texts', []);
                            if (!empty($footer_texts)) :
                                foreach ($footer_texts as $footer_text) :
                                    ?>
                                    <div class="swiper-slide">
                                        <div class="item text-center">
                                            <?php echo wp_kses_post($footer_text['textarea_content']); ?>
                                        </div>
                                    </div>
                                <?php
                                endforeach;
                            else:
                                ?>
                                <div class="swiper-slide">
                                    <div class="item text-center">
                                        <img src="<?php echo Cama_PLG_URI ?>/assets/image/rezi.png" alt=""
                                             class="img-fluid"
                                             width="200">
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="item text-center">
                                        <img src="<?php echo Cama_PLG_URI ?>/assets/image/enamad.png" alt=""
                                             class="img-fluid"
                                             width="200">
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="swiper-button-next d-sm-flex d-none"></div>
                        <div class="swiper-button-prev d-sm-flex d-none"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-desc">
            <div class="row">
                <div class="col-12">
                    <div class="footer-desc-item">
                        <h3 class="font-16 my-3">
                            <?php echo esc_html(get_theme_mod('footer_text_title_setting', '')); ?>
                        </h3>
                        <p class="text-muted font-14">
                            <?php echo esc_html(get_theme_mod('footer_text_setting', '')); ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="copy-right">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <p class="text-muted mb-sm-0 mb-3 font-14">

                        <?php echo esc_html(get_theme_mod('footer_copy_write_setting', '')); ?>
                    </p>
                </div>
                <div class="col-md-4">
                    <div class="social mt-md-0 mt-2">
                        <div class="social-link justify-content-md-end justify-content-center">
                            <?php
                            $social_links = get_theme_mod('social_links', []);

                            if (!empty($social_links)) {
                                foreach ($social_links as $social) {
                                    echo '<a href="' . esc_url($social['network_url']) . '" target="_blank">';
                                    echo '<img src="' . esc_url($social['network_logo']) . '" alt="' . esc_attr($social['network_name']) . '" />';
                                    echo '</a>';
                                }
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<!-- end footer -->

<!-- cart canvas -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="cartCanvas" aria-labelledby="cart canvas">
    <div class="offcanvas-header border-bottom border-1 border-muted">
        <h5 class="offcanvas-title">سبد خرید</h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <div class="row">
            <div class="col-12">
                <div class="row align-items-center">
                    <div class="col-11">
                        <a href="">
                            <div
                                    class="product-row bg-white d-flex align-items-center justify-content-between rounded-4 shadow-md">
                                <div class="image">
                                    <img src="assets/image/product/wach2.jpg" class="img-fluid" width="100" alt="">
                                </div>
                                <div class="desc">
                                    <h6 class="font-14 title text-overflow">گوشی موبایل سامسونگ مدل Galaxy A32
                                        SM-A325F/DS
                                        دو سیم‌کارت ظرفیت 128 گیگابایت </h6>
                                    <div class="price d-flex flex-column justify-content-end mt-2">
                                        <div class="text-end">
                                            <span class="fw-bold font-18 def-color">299,000</span>
                                            <span class="badge main-color-two-bg rounded-pill">25%</span>
                                        </div>
                                        <div class="text-end">
                                                <span
                                                        class="text-muted font-14 text-decoration-line-through">150,000</span>
                                            <span class="text-muted font-14">تومان</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-1 ps-0">
                        <a href="" data-hint="حذف از سبد" class="hint--right">
                            <i class="bi bi-x-circle-fill text-danger fs-4"></i>
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="row align-items-center">
                    <div class="col-11">
                        <a href="">
                            <div
                                    class="product-row bg-white d-flex align-items-center justify-content-between rounded-4 shadow-md">
                                <div class="image">
                                    <img src="assets/image/product/television2.jpg" class="img-fluid" width="100"
                                         alt="">
                                </div>
                                <div class="desc">
                                    <h6 class="font-14 title text-overflow">گوشی موبایل سامسونگ مدل Galaxy A32
                                        SM-A325F/DS
                                        دو سیم‌کارت ظرفیت 128 گیگابایت </h6>
                                    <div class="price d-flex flex-column justify-content-end mt-2">
                                        <div class="text-end">
                                            <span class="fw-bold font-18 def-color">299,000</span>
                                            <span class="badge main-color-two-bg rounded-pill">25%</span>
                                        </div>
                                        <div class="text-end">
                                                <span
                                                        class="text-muted font-14 text-decoration-line-through">150,000</span>
                                            <span class="text-muted font-14">تومان</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-1 ps-0">
                        <a href="" data-hint="حذف از سبد" class="hint--right">
                            <i class="bi bi-x-circle-fill text-danger fs-4"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- end cart canvas -->

<!-- login modal -->
<div class="modal fade auth" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content rounded-5">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="loginModalLabel">ورود به سایت</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="loginform" action="<?php echo wp_login_url(); ?>" method="post">
                    <div class="form-floating mb-3">
                        <input type="text" class="form-control float-input" id="floatingInput"
                               placeholder="تلفن همراه / ایمیل">
                        <label for="floatingInput">تلفن همره / ایمیل</label>
                    </div>
                    <div class="form-floating mb-3">
                        <input type="password" class="form-control float-input" id="floatingPassword"
                               placeholder="کلمه عبور">
                        <label for="floatingPassword">کلمه عبور</label>
                    </div>
                    <div class="d-flex align-items-center justify-content-between flex-wrap mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="rememberME">
                            <label class="form-check-label" for="rememberME">مرا به خاطر بسپار</label>
                        </div>
                        <div class="form-group">
                            <a href="" class="text-primary">فراموشی رمز عبور</a>
                        </div>
                    </div>
                    <div class="form-group">
                        <button type="submit"
                                class="btn main-color-three-bg border-0 rounded-pill w-100 text-white waves-effect waves-light">
                            ورود
                        </button>
                    </div>
                </form>
                <div class="divider">
                    <span>یا</span>
                </div>
                <div class="d-flex justify-content-center">
                    <a href="">عضو نیستی؟ ثبت نام در فروشگاه</a>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- end login modal -->

<!-- product modal -->
<div class="modal fade modal-product" id="productModal" tabindex="-1" aria-labelledby="" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content rounded-4">
            <div class="modal-header">
                <h1 class="modal-title fs-6">گوشی موبایل اپل مدل iPhone XR ظرفیت 128 گیگابایت
                </h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-3 mb-md-0 mb-3">
                        <div class="swiper sw-modal-product">
                            <div class="swiper-wrapper" title="برای بزرگنمایی تصویر دابل کلیک کنید">
                                <div class="swiper-slide">
                                    <div class="swiper-zoom-container">
                                        <img class="img-fluid" src="assets/image/product/product-image1.jpg"/>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="swiper-zoom-container">
                                        <img class="img-fluid" src="assets/image/product/product-image2.jpg"/>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="swiper-zoom-container">
                                        <img class="img-fluid" src="assets/image/product/product-image3.jpg"/>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="swiper-zoom-container">
                                        <img class="img-fluid" src="assets/image/product/product-image4.jpg"/>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="swiper-zoom-container">
                                        <img class="img-fluid" src="assets/image/product/product-image5.jpg"/>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="swiper-zoom-container">
                                        <img class="img-fluid" src="assets/image/product/product-image6.jpg"/>
                                    </div>
                                </div>
                            </div>
                            <div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>
                            <div class="swiper-pagination"></div>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div class="product-meta">
                            <div class="feature py-3">
                                <nav class="navbar">
                                    <ul class="navbar-nav">
                                        <li class="nav-item pb-1 font-14">
                                            <span class="nav-title me-1 fw-bold">برند:</span>
                                            <span class="nav-title-desc text-muted">اپل</span>
                                        </li>
                                        <li class="nav-item pb-1 font-14">
                                            <span class="nav-title me-1 fw-bold">حافظه داخلی:</span>
                                            <span class="nav-title-desc text-muted">256 گیگابایت</span>
                                        </li>
                                        <li class="nav-item pb-1 font-14">
                                            <span class="nav-title me-1 fw-bold">مقدار رم :</span>
                                            <span class="nav-title-desc text-muted">3 گیگابایت</span>
                                        </li>
                                        <li class="nav-item pb-1 font-14">
                                            <span class="nav-title me-1 fw-bold">رزولوشن عکس:</span>
                                            <span class="nav-title-desc text-muted">12 مگاپیکسل</span>
                                        </li>
                                        <li class="nav-item pb-1 font-14">
                                            <span class="nav-title me-1 fw-bold">تعداد سیم کارت:</span>
                                            <span class="nav-title-desc text-muted">تک</span>
                                        </li>
                                        <li class="nav-item pb-1 font-14">
                                            <span class="nav-title me-1 fw-bold">ویژگی‌های خاص:</span>
                                            <span class="nav-title-desc text-muted">مقاوم در برابر آب مناسب عکاسی
                                                    مناسب عکاسی سلفی مناسب بازی مجهز به حس‌گر تشخیص چهره</span>
                                        </li>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="product-variable py-4">
                            <div class="row">
                                <div class="col-md-4 mb-md-0 mb-3">
                                    <div class="box">
                                        <label class="box-label">گارانتی</label>
                                        <form action="">
                                            <select name="" class="form-select">
                                                <option value="">12 ماه گارانتی شرکتی</option>
                                                <option value="">24 ماه گرانتی گرین</option>
                                                <option value="">36 ماه گارانتی شرکتی</option>
                                            </select>
                                        </form>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-md-0 mb-3">
                                    <div class="box">
                                        <label class="box-label">ظرفیت</label>
                                        <form action="">
                                            <select name="" class="form-select">
                                                <option value="">128 گیگابایت</option>
                                                <option value="">256 گیگابایت</option>
                                                <option value="">512 گیگابایت</option>
                                            </select>
                                        </form>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-md-0 mb-3">
                                    <div class="box">
                                        <label class="box-label">انتخاب رنگ</label>
                                        <div class="box-item">
                                            <div class="color-box">
                                                <div class="color-box-item" data-toggle="tooltip"
                                                     data-hint="نام رنگ مورد نظر">
                                                    <span class="color bg-danger hint--top"></span>
                                                </div>
                                                <div class="color-box-item" data-toggle="tooltip"
                                                     data-hint="نام رنگ مورد نظر">
                                                    <span class="color bg-primary hint--top"></span>
                                                </div>
                                                <div class="color-box-item" data-toggle="tooltip"
                                                     data-hint="نام رنگ مورد نظر">
                                                    <span class="color bg-warning hint--top"></span>
                                                </div>
                                                <div class="color-box-item active" data-toggle="tooltip"
                                                     data-hint="نام رنگ مورد نظر">
                                                    <span class="color bg-success hint--top"></span>
                                                </div>
                                                <div class="color-box-item" data-toggle="tooltip"
                                                     data-hint="نام رنگ مورد نظر">
                                                    <span class="color bg-secondary hint--top"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="product-action py-3">
                            <div class="row justify-content-center">
                                <div class="col-md-8">
                                    <form action="">
                                        <div class="d-flex align-items-center justify-content-between flex-wrap">
                                            <div class="cart-counter mb-2 me-2">
                                                <input type="text" name="count" class="counter" value="1">
                                            </div>
                                            <button
                                                    class="btn border-0 mb-2 main-color-one-bg flex-grow-1 rounded-pill py-2 font-14 waves-effect waves-light">
                                                <i class="bi bi-cart-plus"></i>
                                                افزودن به سبد خرید
                                            </button>
                                        </div>
                                    </form>
                                </div>
                                <div class="col-md-4">
                                    <div class="price d-flex flex-column justify-content-end">
                                        <div class="text-end">
                                            <span class="fw-bold font-20 main-color-two-color">299,000</span>
                                            <span class="badge main-color-two-bg rounded-pill">25%</span>
                                        </div>
                                        <div class="d-flex justify-content-end align-items-center">
                                                <span
                                                        class="text-muted font-14 text-decoration-line-through">150,000</span>
                                            <span class="text-muted font-14 ms-2">تومان</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- go top top -->
<div class="progress-wrap d-lg-block d-none">
    <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
        <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"/>
    </svg>
</div>
<!-- end go top top -->

<!-- contact us floating -->
<div id="btncollapzion" class=" btn_collapzion"></div>
<div class="" id="contactOverlay"></div>
<!-- end contact us floating -->


<?php wp_footer(); ?>

<script>
    jQuery(document).ready(function ($) {
        $('#loginform').on('submit', function (e) {
            e.preventDefault(); // جلوگیری از ارسال فرم به روش سنتی

            var data = {
                'action': 'ajaxlogin', // نام اکشن AJAX
                'username': $('#user_login').val(),
                'password': $('#user_pass').val(),
                'security': $('#security').val()
            };

            $.ajax({
                type: 'POST',
                url: ajaxurl, // آدرس AJAX در وردپرس
                data: data,
                success: function (response) {
                    if (response.success) {
                        // اگر لاگین موفق بود، صفحه را رفرش یا به صفحه دیگری بروید
                        window.location.href = response.redirect;
                    } else {
                        // اگر خطا وجود داشت، پیام خطا را در modal نمایش دهید
                        $('#login_error').html(response.message).show();
                    }
                }
            });
        });
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const stackContainer = document.querySelector('.stack-container');
        const cardNodes = document.querySelectorAll('.card-container');
        const consoleNodes = document.querySelectorAll('.writing');
        const perspecNodes = document.querySelectorAll('.perspec');
        const perspec = document.querySelector('.perspec');
        const card = document.querySelector('.card');

        let counter = stackContainer ? stackContainer.children.length : 0;
    });

</script>


<?php
$support_phone = get_theme_mod('support_phone_number', '');
$support_telegram = get_theme_mod('support_telegram_url', '');
$support_whatsapp = get_theme_mod('support_whatsapp_number', '');
?>
<script>
    jQuery(function ($) {
        //// config floating contact
        $('#btncollapzion').Collapzion({
            _child_attribute: [
                <?php
                if ($support_phone){
                ?>
                {
                    'label': 'پشتیبانی تلفنی',
                    'url': 'tel:<?php echo esc_js($support_phone); ?>',
                    'icon': 'bi bi-telephone'
                },
                <?php
                }
                if ($support_telegram){
                ?>
                {
                    'label': 'پشتیبانی تلگرام',
                    'url': '<?php echo esc_js($support_telegram); ?>',
                    'icon': 'bi bi-telegram'
                },
                <?php
                }
                if ($support_whatsapp){
                ?>
                {
                    'label': 'پشتیبانی واتس آپ',
                    'url': 'https://wa.me/<?php echo esc_js($support_whatsapp); ?>',
                    'icon': 'bi-whatsapp'
                },
                <?php
                }
                ?>
            ],
        });
    });
</script>
<!-- ===== end new update -->

</body>
</html>

