<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package cama
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php bloginfo('name'); ?> | <?php is_front_page() ? bloginfo('description') : wp_title(''); ?></title>

    <?php wp_head(); ?>
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/style.css">

</head>

<body <?php body_class(); ?> >
<?php wp_body_open(); ?>

<!-- start header -->
<header>
    <div class="header-top d-lg-block d-none">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="d-flex align-items-center">
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                 class="bi bi-person main-color-one-color" viewBox="0 0 16 16">
                                <path
                                        d="M8 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6Zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm4 8c0 1-1 1-1 1H3s-1 0-1-1 1-4 6-4 6 3 6 4Zm-1-.004c-.001-.246-.154-.986-.832-1.664C11.516 10.68 10.289 10 8 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10Z"/>
                            </svg>
                        </div>
                        <?php if (is_user_logged_in()) : ?>
                            <?php
                            // اطلاعات کاربر جاری
                            $current_user = wp_get_current_user();
                            ?>
                            <span class="fw-bold main-color-one-color font-14 ms-3 me-1">
                                <?php echo esc_html($current_user->display_name); ?>
                            </span>
                            <span class="text-muted font-12">خوش آمدید</span>
                        <?php else : ?>
                            <a href="<?php echo get_home_url() . '/my-account'; ?>" class="font-14 ms-3 me-1">ورود</a>
                            <span class="mx-2">/</span>
                            <a href="<?php echo get_home_url() . '/my-account/?action=register'; ?>" class="font-14">عضویت</a>
                        <?php endif; ?>

                    </div>
                </div>
                <div class="col-lg-6">
                    <nav class="navbar navbar-expand justify-content-end">
                            <?php
                            $header_bar_items = get_theme_mod( 'header_bar_items', [] );

                            if ( ! empty( $header_bar_items ) ) : ?>
                                <ul class="navbar-nav">
                                    <?php foreach ( $header_bar_items as $item ) : ?>
                                        <li class="nav-item">
                                            <a href="<?php echo esc_url( $item['item_link'] ); ?>" class="nav-link font-12 header-top-link">

                                                <?php if ( ! empty( $item['item_icon'] ) ) : ?>
                                                    <!-- آیکون انتخابی توسط کاربر -->
                                                    <i class="<?php echo esc_attr( $item['item_icon'] ); ?>"></i>
                                                <?php else : ?>
                                                    <!-- SVG پیش‌فرض -->
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-patch-check" viewBox="0 0 16 16">
                                                        <path fill-rule="evenodd" d="M10.354 6.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7 8.793l2.646-2.647a.5.5 0 0 1 .708 0z"/>
                                                        <path d="m10.273 2.513-.921-.944.715-.698.622.637.89-.011a2.89 2.89 0 0 1 2.924 2.924l-.01.89.636.622a2.89 2.89 0 0 1 0 4.134l-.637.622.011.89a2.89 2.89 0 0 1-2.924 2.924l-.89-.01-.622.636a2.89 2.89 0 0 1-4.134 0l-.622-.637-.89.011a2.89 2.89 0 0 1-2.924-2.924l.01-.89-.636-.622a2.89 2.89 0 0 1 0-4.134l.637-.622-.011-.89a2.89 2.89 0 0 1 2.924-2.924l.89.01.622-.636a2.89 2.89 0 0 1 4.134 0l-.715.698a1.89 1.89 0 0 0-2.704 0l-.92.944-1.32-.016a1.89 1.89 0 0 0-1.911 1.912l.016 1.318-.944.921a1.89 1.89 0 0 0 0 2.704l.944.92-.016 1.32a1.89 1.89 0 0 0 1.912 1.911l1.318-.016.921.944a1.89 1.89 0 0 0 2.704 0l.92-.944 1.32.016a1.89 1.89 0 0 0 1.911-1.912l-.016-1.318.944-.921a1.89 1.89 0 0 0 0-2.704l-.944-.92.016-1.32a1.89 1.89 0 0 0-1.912-1.911l-1.318.016z"/>
                                                    </svg>
                                                <?php endif; ?>

                                                <span class="ms-1 fw-bold"><?php echo esc_html( $item['item_title'] ); ?></span>
                                            </a>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    <div class="header-bottom shadow-box">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-lg-4 col-7 order-lg-3 order-1">
                    <div class="d-flex flex-column d-lg-flex d-none flex-wrap justify-content-center">
                        <div class="header-bottom-btn">

                            <a href="<?php echo get_home_url() . '/my-favorite' ?>" class="waves-effect waves-light d-flex align-items-center justify-content-center flex-wrap" style="padding: 7px;">
                                <div class="header-bottom-link">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-heart me-2" viewBox="0 0 16 16">
                                        <path d="m8 2.748-.717-.737C5.6.281 2.514.878 1.4 3.053c-.523 1.023-.641 2.5.314 4.385.92 1.815 2.834 3.989 6.286 6.357 3.452-2.368 5.365-4.542 6.286-6.357.955-1.886.838-3.362.314-4.385C13.486.878 10.4.28 8.717 2.01L8 2.748zM8 15C-7.333 4.868 3.279-3.04 7.824 1.143c.06.055.119.112.176.171a3.12 3.12 0 0 1 .176-.17C12.72-3.042 23.333 4.867 8 15z"></path>
                                    </svg>

                                    <span class="text-overflow fw-bold font-14">علاقه مندی ها</span>
                                </div>
                                <span class="position-absolute header-counter-btn main-color-one-bg rounded-pill font-10 text-white badge" style="z-index: 999;">
                                                                        <?php echo count(favorite_id_array()); ?>
                                </span>
                            </a>




                            <a href="<?php echo get_home_url() . '/cart' ?>" class="waves-effect waves-light d-flex align-items-center justify-content-center flex-wrap" style="padding: 7px;">
                                <div class="header-bottom-link">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-cart me-2" viewBox="0 0 16 16">
                                      <path d="M0 1.5A.5.5 0 0 1 .5 1h1a.5.5 0 0 1 .485.379L2.89 6H14.5a.5.5 0 0 1 .49.598l-1.5 7A.5.5 0 0 1 13 14H4a.5.5 0 0 1-.49-.402L1.607 2H.5a.5.5 0 0 1-.5-.5zM4.415 13h8.11l1.285-6H3.128l1.287 6zM6 16a2 2 0 1 0 0-4 2 2 0 0 0 0 4zm7-2a2 2 0 1 1-4 0 2 2 0 0 1 4 0z"/>
                                    </svg>


                                    <span class="text-overflow fw-bold font-14">سبد خرید</span>
                                </div>
                                <span  class="position-absolute header-counter-btn main-color-one-bg rounded-pill font-10 text-white badge cart-count" style="z-index: 999;">
                                    <?php echo esc_html(WC()->cart->get_cart_contents_count()); ?>
                                </span>
                            </a>

<!--                            <a href="--><?php //echo get_home_url() . '/my-account' ?><!--"-->
<!--                               class="header-bottom-link-cat waves-effect waves-light rounded-pill ms-1 font-14 d-flex align-items-center justify-content-center flex-wrap"-->
<!--                               data-bs-toggle="modal" data-bs-target="#loginModal" role="button">-->
                            <a href="<?php echo get_home_url() . '/my-account' ?>"
                               class="header-bottom-link-cat waves-effect waves-light rounded-pill ms-1 font-14 d-flex align-items-center justify-content-center flex-wrap"
                               role="button">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                                     class="bi bi-person-circle me-2" viewBox="0 0 16 16">
                                    <path d="M11 6a3 3 0 1 1-6 0 3 3 0 0 1 6 0z"/>
                                    <path fill-rule="evenodd"
                                          d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8zm8-7a7 7 0 0 0-5.468 11.37C3.242 11.226 4.805 10 8 10s4.757 1.225 5.468 2.37A7 7 0 0 0 8 1z"/>
                                </svg>
                                <span class="fw-bold text-overflow">حساب کاربری</span>
                            </a>
                        </div>
                    </div>
                    <div class="responsive-menu d-lg-none d-block">
                        <button class="btn border-0 btn-responsive-menu" type="button" data-bs-toggle="offcanvas"
                                data-bs-target="#responsiveMenu" aria-controls="responsive menu">
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="currentColor"
                                 class="bi bi-list" viewBox="0 0 16 16">
                                <path fill-rule="evenodd"
                                      d="M2.5 12a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5zm0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5zm0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5z"/>
                            </svg>
                        </button>
                        <div class="offcanvas offcanvas-start" tabindex="-1" id="responsiveMenu"
                             aria-labelledby="responsive menu">
                            <div class="offcanvas-header">
                                <h5 class="offcanvas-title" id="offcanvasRightLabel">فروشگاه</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="offcanvas"
                                        aria-label="Close"></button>
                            </div>
                            <div class="offcanvas-body">
                                <a href="<?php echo get_home_url() ?>" class="text-center d-block mb-3">
                                    <?php
                                    $logo = get_theme_mod('site_logo_setting');
                                    if ($logo) {
                                        echo '<img src="' . esc_url($logo) . '" alt="' . get_bloginfo('name') . '" class="img-fluid" width="200">';
                                    } else {
                                        ?>
                                        <img src="<?php echo Cama_PLG_URI ?>/assets/image/logo.png" alt=""
                                             class="img-fluid"
                                             width="200">
                                        <?php
                                    }
                                    ?>
                                </a>
                                <div class="header-bottom-form mb-4 w-100">
                                    <form name="myform" method="GET" action="<?php echo esc_url(home_url('/')); ?>">
                                        <?php
                                        $args['taxonomy'] = 'category';
                                        $args['name'] = 'category';
                                        $args['class'] = 'dropdown-menu dropdown-menu_category';
                                        ?>
                                        <div class="position-relative">
                                            <input type="text" name="s"
                                                   class="form-control font-14 rounded-pill text-muted py-3 border-muted bg-light"
                                                   value="<?php echo get_search_query(); ?>"
                                                   placeholder="نام محصول مورد نظر خود را وارد کنید">
                                            <button type="submit"
                                                    class="position-absolute top-50 translate-middle-y btn rounded-circle border-0"
                                                    style="left: 5px;">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                     fill="currentColor" class="bi bi-search" viewBox="0 0 16 16">
                                                    <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
                                                </svg>
                                            </button>
                                        </div>
                                    </form>
                                </div>

                                <!--منو برای حالت ریسپانسیو موبایل-->
                                <?php
                                // دریافت نام منوی right-menu
                                $menu_name = wp_get_nav_menu_name('right-menu');

                                // چک کردن اینکه آیا منوی right-menu وجود دارد
                                if ($menu_name) {
                                    echo '<ul class="rm-item-menu navbar-nav">';

                                    // آیتم اصلی با نام منو
                                    echo '<li class="nav-item menu-item-has-children">';
                                    echo '<a href="#" class="nav-link">' . esc_html($menu_name) . '</a>';
                                    echo '<span class="showSubMenu"><i class="bi bi-chevron-left"></i></span>';

                                    // شروع زیرمنوی right-menu
                                    echo '<ul class="navbar-nav h-0">';
                                    wp_nav_menu(array(
                                        'theme_location' => 'right-menu',
                                        'menu_class'     => 'rm-item-menu navbar-nav',
                                        'container'      => false,
                                        'walker'         => new Custom_Mobile_Menu_Walker(),
                                        'items_wrap'     => '%3$s', // فقط آیتم‌های منو را بدون <ul> رندر می‌کند
                                    ));
                                    echo '</ul>'; // پایان زیرمنو

                                    echo '</li>'; // پایان آیتم اصلی
                                    echo '</ul>';
                                }

                                // نمایش منوی اصلی
                                wp_nav_menu(array(
                                    'theme_location' => 'main-menu',
                                    'menu_class'     => 'rm-item-menu navbar-nav',
                                    'container'      => false,
                                    'walker'         => new Custom_Mobile_Menu_Walker(),
                                ));
                                ?>

                                <!--پایان منو برای حالت ریسپانسیو موبایل-->

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-5 order-lg-1 order-2">
                    <div class="row">
                        <a href="<?php echo get_home_url() ?>" class="text-lg-start text-end d-block">
                            <?php
                            $logo = get_theme_mod('site_logo_setting');
                            if ($logo) {
                                echo '<img src="' . esc_url($logo) . '" alt="' . get_bloginfo('name') . '" class="img-fluid" width="200">';
                            } else {
                                ?>
                                <img src="<?php echo Cama_PLG_URI ?>/assets/image/logo.png" alt=""
                                     class="img-fluid"
                                     width="200">
                                <?php
                            }
                            ?>
                        </a>
                    </div>
                </div>
                <div class="col-6 d-lg-flex d-none order-lg-2 order-3">
                    <div class="header-bottom-form me-2 w-100">
                        <form name="myform" method="GET" action="<?php echo esc_url(home_url('/')); ?>">
                            <?php
                            $args['taxonomy'] = 'category';
                            $args['name'] = 'category';
                            $args['class'] = 'dropdown-menu dropdown-menu_category';
                            ?>
                            <div class="position-relative">
                                <input type="text" name="s"
                                       class="form-control font-14 rounded-pill text-muted py-3 border-muted bg-light"
                                       value="<?php echo get_search_query(); ?>"
                                       placeholder="نام محصول مورد نظر خود را وارد کنید">
                                <button type="submit"
                                        class="position-absolute top-50 translate-middle-y btn rounded-circle border-0"
                                        style="left: 5px;">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                         fill="currentColor" class="bi bi-search" viewBox="0 0 16 16">
                                        <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
                                    </svg>
                                </button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</header>

<!-- start mega menu -->

<div class="mega-menu d-lg-block d-none">
    <div class="container-fluid">
        <div class="top-menu-parent">
            <div class="row align-items-center">
                <div class="col-lg-9">
                    <div class="top-menu-menu">
                        <ul class="navbar-nav align-items-center">
                            <li class="position-relative m-0"></li>


                            <?php
                            $menu_name = wp_get_nav_menu_name('right-menu'); // دریافت نام فهرست جایگاه
                            ?>
                            <li class="nav-item main-menu-head">
                                <a href=""
                                   class="nav-link border-animate main-color-one-bg fromCenter btn nav-active fw-bold">
                                    <i class="bi bi-list"></i>
                                    <?php echo esc_html($menu_name) ?>
                                </a>
                                <?php
                                wp_nav_menu(array(
                                    'theme_location' => 'right-menu', // جایگاه منو
                                    'walker' => new Mega_Menu_Walker(), // فراخوانی Walker سفارشی
                                    'container' => false, // جلوگیری از افزودن div اضافی
                                    'menu_class' => 'main-menu mega-container', // کلاس اصلی UL
                                ));
                                ?>

                            </li>


                            <?php
                            wp_nav_menu(array(
                                'theme_location' => 'main-menu', // جایگاه منو
                                'container' => false,             // حذف تگ container
                                'items_wrap' => '%3$s',           // حذف تگ <ul> و <li> های داخلی را مستقیماً نمایش می‌دهد
                                'walker' => new Custom_Walker_Nav_Menu() // استفاده از Walker سفارشی
                            ));
                            ?>

                        </ul>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="d-flex align-items-center top-header-call float-end d-xl-flex d-none">
                        <div class="top-header-call-title me-3">
                            <h6 class="text-center h5">
                                <a href="tel:<?php echo esc_html(get_theme_mod('phone_number', '')); ?>"><?php echo esc_html(get_theme_mod('phone_number', '')); ?></a>
                            </h6>
                            <p class="text-muted">
                                <?php echo esc_html(get_theme_mod('header_phone_text', '')); ?>
                            </p>
                        </div>
                        <div class="top-header-call-icon">
                            <i class="bi bi-telephone-forward fs-3"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- end mega menu -->

<!-- mobile footer -->

<div class="mobile-footer d-lg-none d-table justify-content-center shadow-box bg-white position-fixed bottom-0 p-2 w-100"
     style="z-index: 100;table-layout: fixed;">
    <ul class="d-table-row">
        <li class="d-table-cell pointer" onclick="topFunction()">
            <div class="mf-link nav-link text-center">
                <span class="d-block mf-link-icon"><i class="bi bi-chevron-up font-20"></i></span>
                <span class="mt-1 h6 mf-link-title">بالا</span>
            </div>
        </li>
        <li class="d-table-cell">
            <a href="<?php echo get_home_url() . '/my-favorite' ?>" class="mf-link nav-link text-center">
                <div class="mf-link-icon position-relative d-table mx-auto">
                    <i class="bi bi-heart font-20"></i>
                    <span class="position-absolute main-color-one-bg rounded-pill font-10 text-white badge" style="right:-40%;bottom:-5px;">
                        <?php echo count(favorite_id_array()); ?>
                    </span>
                </div>
                <span class="mt-1 h6 mf-link-title">علاقه مندی ها</span>
            </a>
        </li>
        <li class="d-table-cell"><a href="" class="mf-link nav-link text-center">
                <span class="d-block mf-link-icon"><i class="bi bi-house font-20"></i></span>
                <span class="mt-1 h6 mf-link-title">صفحه اصلی</span>
            </a></li>
        <li class="d-table-cell"><a href="<?php echo get_home_url() . '/my-account' ?>" class="mf-link nav-link text-center">
                <div class="position-relative mf-link-icon d-table mx-auto">
                    <span class="d-block mf-link-icon"><i class="bi bi-arrow-left-right font-20"></i></span>
                </div>
                <span class="mt-1 h6 mf-link-title">حساب کاربری</span>
            </a></li>
        <li class="d-table-cell">
            <a class="mf-link nav-link text-center"  href="<?php echo get_home_url() . '/cart'; ?>" role="button" >
                <div class="position-relative mf-link-icon d-table mx-auto">
                    <span class="d-block mf-link-icon"><i class="bi bi-bag font-20"></i></span>
                    <span class="position-absolute main-color-one-bg rounded-pill font-10 text-white badge cart-count" style="right:-60%;bottom:-5px;">
                <?php echo esc_html(WC()->cart->get_cart_contents_count()); ?>
            </span>
                </div>
                <span class="mt-1 h6 mf-link-title">سبد خرید</span>
            </a>
        </li>

    </ul>
</div>

<!-- end mobile footer -->



