<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package cama
 */

get_header();
?>

<!-- bread crumb -->
<div class="content">
    <div class="container-fluid">
        <nav aria-label="breadcrumb" class="my-lg-0 my-2">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?php echo home_url(); ?>" class="font-14 text-muted">خانه</a></li>
                <li class="breadcrumb-item active main-color-one-color font-14" aria-current="page">نتایج جستجو برای: "<?php echo get_search_query(); ?>"</li>
            </ol>
        </nav>
    </div>
</div>

<main id="primary" class="site-main">
    <?php if ( have_posts() ) { ?>

        <!-- start main-data -->
        <div class="content">
            <div class="container-fluid">
                <div class="row gy-2">
                    <div class="col-lg-3 order-lg-1 order-2">
                        <div class="item-boxs">
                            <!-- دسته‌بندی محصولات -->
                            <div class="item-box bg-white shadow-box">
                                <div class="title">
                                    <h6 class="font-14">دسته بندی محصولات</h6>
                                </div>
                                <div class="desc">
                                    <?php
                                    $product_categories = get_terms( 'product_cat', array(
                                        'hide_empty' => true,
                                    ));
                                    foreach ( $product_categories as $category ) {
                                        ?>
                                        <a href="<?php echo get_term_link( $category ); ?>">
                                            <div class="d-flex align-items-center justify-content-between flex-wrap mb-3">
                                                <div class="d-flex align-items-center">
                                                    <div class="box-icon"><i class="bi bi-tag"></i></div>
                                                    <span><?php echo $category->name; ?></span>
                                                </div>
                                                <div>
                                                    <span class="fw-bold font-16">(<?php echo $category->count; ?>)</span>
                                                </div>
                                            </div>
                                        </a>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>

                            <!-- برچسب‌های محصولات -->
                            <div class="item-box bg-white shadow-box">
                                <div class="title">
                                    <h6 class="font-14">برچسب‌های محصولات</h6>
                                </div>
                                <div class="desc">
                                    <div class="d-flex align-items-center flex-wrap">
                                        <?php
                                        $product_tags = get_terms( 'product_tag' );
                                        foreach ( $product_tags as $tag ) {
                                            ?>
                                            <div class="blog-tag">
                                                <a href="<?php echo get_term_link( $tag ); ?>"><?php echo $tag->name; ?></a>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-9 order-lg-2 order-1">
                        <div class="content-box">
                            <div class="row gy-4">
                                <?php while ( have_posts() ) : the_post(); ?>
                                    <?php if ( 'product' === get_post_type() ) : ?>
                                        <div class="col-md-4 col-sm-6">
                                            <div class="shadow-box">
                                                <div class="card shadow-inner border-muted">
                                                    <!-- تصویر محصول -->
                                                    <div class="image-blog text-center">
                                                        <a href="<?php the_permalink(); ?>">
                                                            <?php if ( has_post_thumbnail() ) : ?>
                                                                <img src="<?php the_post_thumbnail_url('medium'); ?>" class="img-fluid rounded-2" alt="<?php the_title(); ?>">
                                                            <?php else : ?>
                                                                <img src="<?php echo get_template_directory_uri(); ?>/assets/image/default-product.png" class="img-fluid rounded-2" alt="Default Image">
                                                            <?php endif; ?>
                                                        </a>
                                                    </div>

                                                    <!-- محتویات کارت محصول -->
                                                    <div class="card-body">
                                                        <h5 class="card-title h5 text-overflow-2"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>

                                                        <!-- قیمت محصول -->
                                                        <p class="card-text font-14 mt-2"><?php woocommerce_template_loop_price(); ?></p>

                                                        <!-- دکمه مشاهده محصول -->
                                                        <a href="<?php the_permalink(); ?>" class="span-primary rounded-3 font-14 shadow-md">مشاهده محصول</a>

                                                        <!-- امتیاز محصول -->
                                                        <div class="my-card-footer mt-3 d-flex justify-content-center border-top pt-2 border-muted">
                                                            <?php if ( function_exists('woocommerce_template_loop_rating') ) : ?>
                                                                <div class="star-rating">
                                                                    <?php woocommerce_template_loop_rating(); ?>
                                                                </div>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endwhile; ?>
                            </div>

                            <!-- صفحه‌بندی -->
                            <div class="my-paginate my-4">
                                <?php echo get_the_posts_pagination(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end main-data -->

    <?php } else { ?>
        <!-- محتوایی برای نمایش وجود ندارد -->
        <div class="content">
            <div class="container-fluid">
                <p>محصولی یافت نشد.</p>
            </div>
        </div>
    <?php } ?>
</main><!-- #main -->

<?php get_footer(); ?>
