
<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package cama
 */

get_header();
?>




<div class="content">
    <div class="container-fluid">
        <div class="row gy-2">
            <div class="col-lg-3 order-lg-1 order-2">
                <div class="item-boxs">
                    <div class="item-box bg-white shadow-box">
                        <div class="title">
                            <h6 class="font-14">دسته بندی ها</h6>
                        </div>
                        <div class="desc">
                            <?php
                            // گرفتن دسته‌بندی‌هایی که حداقل یک مطلب دارند
                            $categories = get_categories(array(
                                'hide_empty' => true, // دسته‌هایی که مطالبی ندارند را حذف می‌کند
                            ));
                            foreach ($categories as $category) {
                                ?>
                                <a href="<?php echo get_category_link($category->term_id); ?>">
                                    <div class="d-flex align-items-center justify-content-between flex-wrap mb-3">
                                        <div class="d-flex align-items-center">
                                            <div class="box-icon"><i class="bi bi-tag"></i></div>
                                            <span><?php echo $category->name; ?></span>
                                        </div>
                                        <div>
                                            <span class="fw-bold font-16">(<?php echo $category->count; ?>)</span>
                                        </div>
                                    </div>
                                </a>
                                <?php
                            }
                            ?>
                        </div>
                    </div>
                    <div class="item-box bg-white shadow-box">
                        <div class="title">
                            <h6 class="font-14">برچسب ها</h6>
                        </div>
                        <div class="desc">
                            <div class="d-flex align-items-center flex-wrap">
                                <?php
                                // گرفتن تمام برچسب‌ها
                                $tags = get_tags();
                                foreach ($tags as $tag) {
                                    ?>
                                    <div class="blog-tag">
                                        <a href="<?php echo get_tag_link($tag->term_id); ?>"><?php echo $tag->name; ?></a>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-9 order-lg-2 order-1">
                <div class="content-box">
                    <div class="row gy-2">
                        <div class="col-12">
                            <div class="blog-detail-title mb-4">
                                <h3 class="main-title"><?php the_title(); ?></h3>
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="shadow-box">
                                <?php if (has_post_thumbnail()) : ?>
                                    <?php the_post_thumbnail('full', ['class' => 'img-fluid rounded-3']); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="blog-meta w-100 shadow-box text-justify rounded-4 my-3 py-3">
                                <ul class="navbar-nav flex-row w-100 justify-content-around">
                                    <li class="nav-item">
                                        <div class="item">
                                            <div class="title d-grid gap-2">
                                                <div class="d-flex justify-content-center">
                                                    <h6 class="font-12 text-muted badge rounded-pill bg-light fw-normal py-2">دسته بندی</h6>
                                                </div>
                                                <h6 class="font-16 text-center"><?php the_category(', '); ?></h6>
                                            </div>
                                        </div>
                                    </li>
                                    <li class="nav-item">
                                        <div class="item">
                                            <div class="d-flex align-items-center">
                                                <div class="icon blog-writer-icon">
                                                    <div class="box-icon rounded-circle" style="width: 40px; height:40px; margin-top: auto; margin-bottom: auto;">
                                                        <i class="bi bi-person fs-3 main-color-one-color"></i>
                                                    </div>
                                                </div>
                                                <div class="title d-grid gap-2">
                                                    <div class="d-flex justify-content-center">
                                                        <h6 class="font-12 text-muted badge rounded-pill bg-light fw-normal py-2">نویسنده</h6>
                                                    </div>
                                                    <?php
                                                    global $post;
                                                    $author = get_the_author_meta('display_name', $post->post_author); // دریافت نام نویسنده
                                                    ?>
                                                    <h6 class="font-16 text-center"><?php echo esc_html($author); ?></h6> <!-- نمایش نام نویسنده -->
                                                
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                    <li class="nav-item">
                                        <div class="item">
                                            <div class="title d-grid gap-2">
                                                <div class="d-flex justify-content-center">
                                                    <h6 class="font-12 text-muted badge rounded-pill bg-light fw-normal py-2">زمان مورد نیاز برای مطالعه</h6>
                                                </div>
                                                <?php
                                                // دریافت توضیحات پست
                                                $content = get_the_content();
                                                $char_count = strlen(strip_tags($content)); // تعداد حروف بدون تگ‌های HTML

                                                // محاسبه زمان خواندن به دقیقه
                                                $reading_time = max(1, ceil($char_count / 1500)); // تقسیم بر 500 و حداقل 1 دقیقه

                                                // نمایش زمان خواندن
                                                ?>
                                                <h6 class="font-16 text-center"><?php echo $reading_time; ?> دقیقه</h6>

                                            </div>
                                        </div>
                                    </li>

                                    <li class="nav-item">
                                        <div class="item">
                                        <div class="like-post title d-grid gap-2">
                                            <div class="d-flex justify-content-center">
                                                <h6 class="font-12 text-muted badge rounded-pill bg-light fw-normal py-2"><?php echo get_post_meta(get_the_ID(), 'likes_count', true) ?: 0; ?> نفر این پست را پسندیدند</h6>
                                            </div>
                                            <?php if (is_user_logged_in()) :
                                            $user_id = get_current_user_id();
                                            $liked_posts = get_user_meta($user_id, 'liked_posts', true);
                                            $post_id = get_the_ID();
                                            $is_liked = is_array($liked_posts) && in_array($post_id, $liked_posts);
                                            ?>

                                                <button id="like-button" class="main-color-one-bg" data-post-id="<?php echo $post_id; ?>" data-liked="<?php echo $is_liked ? 'yes' : 'no'; ?>">
                                                    <?php if ($is_liked): ?>
                                                        نمی‌پسندم! <i class="fas fa-heart-broken"></i>
                                                    <?php else: ?>
                                                        پسندیدم <i class="fas fa-heart"></i>
                                                    <?php endif; ?>
                                                </button>

                                            <?php endif; ?>
                                        </div>
                                        </div>
                                    </li>


                                </ul>
                            </div>
                            <div class="blog-desc-short font-14 bg-light p-4 shadow-box text-justify rounded-4 my-3">
                                <p><?php echo wp_trim_words(get_the_content(), 40); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="blog-desc">
                        <?php the_content(); ?>
                    </div>
                    <div class="blog-desc-foot">
                        <div class="row">
                            <?php
                            // پست قبلی
                            $prev_post = get_previous_post();
                            if (!empty($prev_post)) {
                                $prev_post_thumbnail = get_the_post_thumbnail($prev_post->ID, 'thumbnail');
                                ?>
                                <div class="col-lg-4">
                                    <a href="<?php echo get_permalink($prev_post->ID); ?>">
                                        <div class="item right">
                                            <div class="card mb-3 shadow-md">
                                                <div class="row g-0">
                                                    <div class="col-md-4">
                                                        <?php echo $prev_post_thumbnail; ?>
                                                    </div>
                                                    <div class="col-md-8">
                                                        <div class="card-body">
                                                            <h5 class="card-title font-16">نوشته قبلی</h5>
                                                            <p class="card-text text-overflow-2 font-14 text-muted">
                                                                <?php echo esc_html($prev_post->post_title); ?>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                                <?php
                            }

                            // پست بعدی
                            $next_post = get_next_post();
                            if (!empty($next_post)) {
                                $next_post_thumbnail = get_the_post_thumbnail($next_post->ID, 'thumbnail');
                                ?>
                                <div class="col-lg-4 offset-lg-4">
                                    <a href="<?php echo get_permalink($next_post->ID); ?>">
                                        <div class="item left">
                                            <div class="card mb-3 shadow-md">
                                                <div class="row g-0">
                                                    <div class="col-md-4">
                                                        <?php echo $next_post_thumbnail; ?>
                                                    </div>
                                                    <div class="col-md-8">
                                                        <div class="card-body">
                                                            <h5 class="card-title font-16">نوشته بعدی</h5>
                                                            <p class="card-text text-overflow-2 font-14 text-muted">
                                                                <?php echo esc_html($next_post->post_title); ?>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                                <?php
                            }
                            ?>
                        </div>

                        <div class="right"></div>
                    </div>
                    <div class="blog-desc-tag my-3">
                        <h3 class="font-16 mb-2"><i class="bi bi-tag me-1"></i> برچسب‌ها</h3>
                        <div class="d-flex align-items-center flex-wrap">
                            <?php
                            $tags = get_the_tags();
                            if ($tags) {
                                foreach ($tags as $tag) {
                                    // نمایش برچسب با لینک به صفحه برچسب
                                    echo '<div class="blog-tag">';
                                    echo '<a href="' . esc_url(get_tag_link($tag->term_id)) . '">' . esc_html($tag->name) . '</a>';
                                    echo '</div>';
                                }
                            } else {
                                echo '<div class="blog-tag"><span>بدون برچسب</span></div>';
                            }
                            ?>
                        </div>
                    </div>

                    <div class="blog-desc-tag my-3">
                        <h3 class="font-16 mb-2"><i class="bi bi-folder me-1"></i>دسته بندی</h3>
                        <div class="d-flex align-items-center flex-wrap">
                            <?php
                            $categories = get_the_category();
                            if (!empty($categories)) {
                                foreach ($categories as $category) {
                                    // نمایش دسته‌بندی با لینک به صفحه دسته‌بندی
                                    echo '<div class="blog-tag">';
                                    echo '<a href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a>';
                                    echo '</div>';
                                }
                            } else {
                                echo '<div class="blog-tag"><span>بدون دسته‌بندی</span></div>';
                            }
                            ?>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>
</div>
<!-- end main-data -->

<!-- start slider -->
<div class="content">
    <div class="product-box blog-box">
        <div class="container-fluid">
            <div class="parent">
                <div class="content-title">
                    <div class="item">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                             class="bi bi-box-seam" viewBox="0 0 16 16">
                            <path
                                    d="M8.186 1.113a.5.5 0 0 0-.372 0L1.846 3.5l2.404.961L10.404 2l-2.218-.887zm3.564 1.426L5.596 5 8 5.961 14.154 3.5l-2.404-.961zm3.25 1.7-6.5 2.6v7.922l6.5-2.6V4.24zM7.5 14.762V6.838L1 4.239v7.923l6.5 2.6zM7.443.184a1.5 1.5 0 0 1 1.114 0l7.129 2.852A.5.5 0 0 1 16 3.5v8.662a1 1 0 0 1-.629.928l-7.185 2.874a.5.5 0 0 1-.372 0L.63 13.09a1 1 0 0 1-.63-.928V3.5a.5.5 0 0 1 .314-.464L7.443.184z" />
                        </svg>
                        <h5 class="title">مطالب مرتبط</h5>
                    </div>
                    <div class="item">
                        <i class="bi bi-box-arrow-in-left fs-5"></i>
                        <a href="">
                            <h5 class="title">مشاهده همه</h5>
                        </a>
                    </div>
                </div>
                <div class="swiper py-5" id="swiper-box-two">
                    <div class="swiper-wrapper">
                        <?php
                        $related_posts = get_posts(array(
                            'category__in' => wp_get_post_categories(get_the_ID()),
                            'post__not_in' => array(get_the_ID()),
                            'posts_per_page' => 5,
                        ));

                        if ($related_posts) :
                            foreach ($related_posts as $post) : setup_postdata($post); ?>
                                <div class="swiper-slide">
                                    <a href="<?php the_permalink(); ?>">
                                        <div class="image-blog text-center">
                                            <?php the_post_thumbnail('full', ['class' => 'img-fluid']); ?>
                                            <div class="blog-desc position-absolute bottom-0">
                                                <h6 class="font-14"><?php the_title(); ?></h6>
                                                <div class="d-flex justify-content-between align-items-center my-2">
                                                    <div class="like">
                                                        <span class="icon">
                                                            <i class="bi bi-heart"></i>
                                                        </span>
                                                        <span class="counter font-12"><?php echo get_post_meta(get_the_ID(), 'likes_count', true) ?: 0; ?></span>
                                                    </div>
                                                    <div class="date d-flex align-items-center">
                                                        <div class="icon me-1"><i class="bi bi-calendar-event"></i></div>
                                                        <span class="font-12"><?php echo get_the_date(); ?></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            <?php endforeach;
                            wp_reset_postdata();
                        endif; ?>
                    </div>
                    <div class="swiper-pagination"></div>
                    <div class="swiper-button-next d-sm-flex d-none"></div>
                    <div class="swiper-button-prev d-sm-flex d-none"></div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- end slider -->

<!-- FORM -->

<div class="content">
    <div class="container-fluid">
        <div class="content-box">
            <?php
            if ( comments_open() || get_comments_number() ) :
                comments_template();
            endif;
            ?>
        </div>
    </div>
</div>
</div>

<!-- end FORM -->

<?php
get_sidebar();
get_footer();
?>
