<?php
/**
 * The template for displaying wishlist page
 * Template Name: wishlist
 *
 * @package cama
 */

get_header();

// Get favorite posts
$favorite_posts = favorite_id_array();
?>

<!-- bread crumb -->
<div class="content">
    <div class="container-fluid">
        <nav aria-label="breadcrumb" class="my-lg-0 my-2">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?php echo home_url(); ?>" class="font-14 text-muted">خانه</a></li>
                <li class="breadcrumb-item active main-color-one-color font-14" aria-current="page">علاقه‌مندی‌ها</li>
            </ol>
        </nav>
    </div>
</div>

<main id="primary" class="site-main">
    <?php if ( !empty($favorite_posts) ) { ?>

        <!-- start main-data -->
        <div class="content">
            <div class="container-fluid">
                <div class="row gy-2">
                    <div class="col-lg-3 order-lg-1 order-2">
                        <div class="item-boxs">
                            <!-- دسته‌بندی محصولات -->
                            <div class="item-box bg-white shadow-box">
                                <div class="title">
                                    <h6 class="font-14">دسته بندی محصولات</h6>
                                </div>
                                <div class="desc">
                                    <?php
                                    $product_categories = get_terms( 'product_cat', array(
                                        'hide_empty' => true,
                                    ));
                                    foreach ( $product_categories as $category ) {
                                        ?>
                                        <a href="<?php echo get_term_link( $category ); ?>">
                                            <div class="d-flex align-items-center justify-content-between flex-wrap mb-3">
                                                <div class="d-flex align-items-center">
                                                    <div class="box-icon"><i class="bi bi-tag"></i></div>
                                                    <span><?php echo $category->name; ?></span>
                                                </div>
                                                <div>
                                                    <span class="fw-bold font-16">(<?php echo $category->count; ?>)</span>
                                                </div>
                                            </div>
                                        </a>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>

                            <!-- برچسب‌های محصولات -->
                            <div class="item-box bg-white shadow-box">
                                <div class="title">
                                    <h6 class="font-14">برچسب‌های محصولات</h6>
                                </div>
                                <div class="desc">
                                    <div class="d-flex align-items-center flex-wrap">
                                        <?php
                                        $product_tags = get_terms( 'product_tag' );
                                        foreach ( $product_tags as $tag ) {
                                            ?>
                                            <div class="blog-tag">
                                                <a href="<?php echo get_term_link( $tag ); ?>"><?php echo $tag->name; ?></a>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-9 order-lg-2 order-1">
                        <div class="content-box">
                            <div class="row gy-4">
                                <?php
                                $args = array(
                                    'post_type' => 'product',
                                    'post__in' => $favorite_posts, // Only show posts in favorite array
                                    'posts_per_page' => -1, // Show all products in favorites
                                );
                                $wishlist_query = new WP_Query( $args );

                                if ( $wishlist_query->have_posts() ) :
                                    while ( $wishlist_query->have_posts() ) : $wishlist_query->the_post();
                                        ?>
                                        <div class="col-md-4 col-sm-6">
                                            <div class="shadow-box widhlist-box">
                                                <?php
                                                productBox2(get_the_ID(), false);
                                                ?>
                                            </div>
                                        </div>
                                    <?php
                                    endwhile;
                                else :
                                    ?>
                                    <p>محصولی در علاقه‌مندی‌ها یافت نشد.</p>
                                <?php
                                endif;
                                wp_reset_postdata();
                                ?>
                            </div>

                            <!-- صفحه‌بندی -->
                            <div class="my-paginate my-4">
                                <?php echo get_the_posts_pagination(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end main-data -->

    <?php } else { ?>
        <!-- محتوایی برای نمایش وجود ندارد -->
        <div class="content">
            <div class="container-fluid">
                <p>هنوز محصولی به علاقه‌مندی‌های شما اضافه نشده است.</p>
            </div>
        </div>
    <?php } ?>
</main><!-- #main -->

<?php get_footer(); ?>
