<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */

defined('ABSPATH') || exit;

get_header();
?>


    <div class="content">
        <div class="container-fluid">
            <?php
            /**
             * Hook: woocommerce_before_main_content.
             *
             * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
             * @hooked woocommerce_breadcrumb - 20
             * @hooked WC_Structured_Data::generate_website_data() - 30
             */
            do_action('woocommerce_before_main_content');
            ?>


            <div class="row">
                <div class="col-lg-3 d-lg-block d-none">
                    <div class="item-boxs">
                        <div class="item-box bg-white shadow-box">
                            <div class="title">
                                <div class="d-flex align-items-center justify-content-between">
                                    <h6 class="font-14">محدوده قیمت</h6>
                                    <a class="btn border-0" data-bs-toggle="collapse" href="#collapsePrice1"
                                       role="button" aria-expanded="false">
                                        <i class="bi bi-chevron-up"></i>
                                    </a>
                                </div>
                            </div>
                            <div class="desc collapse show" id="collapsePrice1">
                                <form action="" method="get">
                                    <div class="form-group">
                                        <input type="hidden" id="min_price" name="min_price" value="50000">
                                        <input type="hidden" id="max_price" name="max_price" value="5000000">
                                        <input type="range" class="catRange" name="range[]">
                                        <div class="show-more-btn mt-2 text-center">
                                            <button class="btn border-0 main-color-one-bg shadow-box waves-effect waves-light"
                                                    type="submit">
                                                اعمال فیلتر <i class="bi bi-filter"></i>
                                            </button>
                                        </div>
                                    </div>
                                </form>

                            </div>
                        </div>
                        
                        <div class="item-box bg-white shadow-box">
                            <div class="title">
                                <div class="d-flex align-items-center justify-content-between">
                                    <h6 class="font-14">نمایش محصولات</h6>
                                    <a class="btn border-0" data-bs-toggle="collapse" href="#collapsePrice1"
                                       role="button" aria-expanded="false">
                                        <i class="bi bi-chevron-up"></i>
                                    </a>
                                </div>
                            </div>
                            <div class="desc collapse show" id="inStockShow">
                                <div class="form-check form-switch d-flex align-items-center gap-2">
                                    <input class="form-check-input" type="checkbox" id="toggleInStock" >
                                    <label class="form-check-label font-14" for="toggleInStock">فقط نمایش محصولات موجود</label>
                                </div>
                            </div>
                        </div>


                        <div class="item-box bg-white shadow-box">
                            <div class="title">
                                <div class="d-flex align-items-center justify-content-between">
                                    <h6 class="font-14">جستجو</h6>
                                    <a class="btn border-0" data-bs-toggle="collapse" href="#collapseItemBoxSearch"
                                       role="button" aria-expanded="false">
                                        <i class="bi bi-chevron-up"></i>
                                    </a>
                                </div>
                            </div>
                            <div class="desc collapse show" id="collapseItemBoxSearch">
                                <form name="myform" method="GET" action="<?php echo esc_url(home_url('/')); ?>">
                                    <?php
                                    $args['taxonomy'] = 'category';
                                    $args['name'] = 'category';
                                    $args['class'] = 'dropdown-menu dropdown-menu_category';
                                    ?>
                                    <div class="position-relative">
                                        <input type="text" name="s"
                                               class="form-control font-14 rounded-pill text-muted py-3 border-muted bg-light"
                                               value="<?php echo get_search_query(); ?>"
                                               placeholder="نام محصول مورد نظر خود را وارد کنید">
                                        <button type="submit"
                                                class="position-absolute top-50 translate-middle-y btn rounded-circle border-0"
                                                style="left: 5px;">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                 fill="currentColor" class="bi bi-search" viewBox="0 0 16 16">
                                                <path
                                                        d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
                                            </svg>
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>

                    <?php
                    if (get_theme_mod('storepage_display_categories_setting', true)) {
                        ?>
                        <div class="item-box bg-white shadow-box">
                            <div class="title">
                                <h6 class="font-14">دسته بندی ها</h6>
                            </div>
                            <div class="desc">
                                <?php
                                $product_categories = get_terms(array(
                                    'taxonomy' => 'product_cat',
                                    'hide_empty' => true,
                                    'parent' => 0,
                                ));

                                if (!empty($product_categories) && !is_wp_error($product_categories)) {
                                    foreach ($product_categories as $category) {
                                        ?>
                                        <a href="<?php echo get_term_link($category); ?>">
                                            <div class="d-flex align-items-center justify-content-between flex-wrap mb-3">
                                                <div class="d-flex align-items-center">
                                                    <div class="box-icon"><i class="bi bi-tag"></i></div>
                                                    <span><?php echo $category->name; ?></span>
                                                </div>
                                                <div>
                                                    <span class="fw-bold font-16">(<?php echo $category->count; ?>)</span>
                                                </div>
                                            </div>
                                        </a>
                                        <?php
                                    }
                                } else {
                                    echo '<p>هیچ دسته‌بندی یافت نشد.</p>';
                                }
                                ?>
                            </div>
                        </div>
                        <?php
                    }
                    ?>

                    <?php
                    if (get_theme_mod('storepage_display_tags_setting', true)) {
                        ?>
                        <div class="item-box bg-white shadow-box">
                            <div class="title">
                                <h6 class="font-14">برچسب ها</h6>
                            </div>
                            <div class="desc">
                                <?php
                                $product_tags = get_terms(array(
                                    'taxonomy' => 'product_tag',
                                    'hide_empty' => true,
                                    'parent' => 0,
                                ));

                                if (!empty($product_tags) && !is_wp_error($product_tags)) {
                                    foreach ($product_tags as $tag) {
                                        ?>
                                        <a href="<?php echo get_term_link($tag); ?>">
                                            <div class="d-flex align-items-center justify-content-between flex-wrap mb-3">
                                                <div class="d-flex align-items-center">
                                                    <div class="box-icon"><i class="bi bi-tag"></i></div>
                                                    <span><?php echo $tag->name; ?></span>
                                                </div>
                                                <div>
                                                    <span class="fw-bold font-16">(<?php echo $tag->count; ?>)</span>
                                                </div>
                                            </div>
                                        </a>
                                        <?php
                                    }
                                } else {
                                    echo '<p>هیچ برچسبی یافت نشد.</p>';
                                }
                                ?>
                            </div>
                        </div>
                        <?php
                    }
                    ?>

                    </div>

                </div>
                <div class="col-lg-9">
                    <div class="filter-items shadow-box">
                        
                        <div class="items">
                            <div class="link d-md-block d-none">

                            </div>
                            <div class="count">
                                <div class="font-14">
                                    <div class="woocommerce-sorting d-flex">
                                        <?php
                                        /**
                                         * Hook: woocommerce_before_shop_loop.
                                         *
                                         * @hooked woocommerce_result_count - 20
                                         * @hooked woocommerce_catalog_ordering - 30
                                         */
                                        do_action('woocommerce_before_shop_loop');
                                        ?>

                                    </div>
                                </div>
                            </div>
                            <!--                            <div class="link-responsive d-md-none d-block">-->
                            <!--                                --><?php
                            //                                /**
                            //                                 * Hook: woocommerce_before_shop_loop.
                            //                                 *
                            //                                 * @hooked woocommerce_result_count - 20
                            //                                 * @hooked woocommerce_catalog_ordering - 30
                            //                                 */
                            //                                do_action( 'woocommerce_before_shop_loop' );
                            //                                ?>
                            <!--                            </div>-->
                        </div>
                    </div>
                    <div class="row">
                        <?php
                        if (woocommerce_product_loop()) {

//
                            if (wc_get_loop_prop('total')) {
                                while (have_posts()) {
                                    the_post();
                                    global $product;

                                    ?>

                                    <div class="col-lg-4 col-sm-6 archive-box <?php if (! $product->is_in_stock()) echo 'out-of-stock'; ?>">
                                        <?php productBox2(get_the_ID(), false); ?>
                                    </div>


                                    <?php
                                    wp_reset_postdata();
                                }
                            }

                            woocommerce_product_loop_end();

                            /**
                             * Hook: woocommerce_after_shop_loop.
                             *
                             * @hooked woocommerce_pagination - 10
                             */
                            do_action('woocommerce_after_shop_loop');
                        } else {
                            /**
                             * Hook: woocommerce_no_products_found.
                             *
                             * @hooked wc_no_products_found - 10
                             */
                            do_action('woocommerce_no_products_found');
                        }
                        ?>


                    </div>


                    <div class="col-12 archive-description">
                        <?php
                        /**
                         * Hook: woocommerce_archive_description.
                         *
                         * @hooked woocommerce_taxonomy_archive_description - 10
                         * @hooked woocommerce_product_archive_description - 10
                         */
                        do_action('woocommerce_archive_description');
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end main content page -->
    
    
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        const toggle = document.getElementById('toggleInStock');
        const allProducts = document.querySelectorAll('.archive-box');
    
        // بازیابی وضعیت ذخیره‌شده
        const savedStatus = localStorage.getItem('inStockFilterEnabled');
    
        if (savedStatus !== null) {
            toggle.checked = savedStatus === 'true';
        }
    
        // تابع برای فیلتر کردن محصولات
        function filterProducts() {
            allProducts.forEach(function (item) {
                if (item.classList.contains('out-of-stock')) {
                    item.style.display = toggle.checked ? 'none' : '';
                }
            });
        }
    
        // اجرای اولیه
        filterProducts();
    
        // ذخیره‌سازی وضعیت و اعمال فیلتر هنگام تغییر
        toggle.addEventListener('change', function () {
            localStorage.setItem('inStockFilterEnabled', toggle.checked);
            filterProducts();
        });
    });
    </script>



<?php


get_footer();

