<?php
/**
 * Custom Thankyou page with header and footer
 *
 * @package WooCommerce\Templates
 * @version 8.1.0
 *
 * @var WC_Order $order
 */

defined( 'ABSPATH' ) || exit;

get_header(); // Include site header
?>

<div class="woocommerce-order">

    <?php if ( $order ) :

        do_action( 'woocommerce_before_thankyou', $order->get_id() );

        if ( $order->has_status( 'failed' ) ) : ?>

            <!-- Failed Transaction Message -->
            <div class="content">
                <div class="container-fluid">
                    <div class="payment-content py-20 mt-5">
                        <div class="row justify-content-center">
                            <div class="col-lg-6">
                                <div class="alert-box ab-nsuccess">
                                    <div class="title">
                                        <h5 class="h5">پرداخت ناموفق!</h5>
                                    </div>
                                    <div class="desc">
                                        <p class="text-muted font-14">پرداخت شما ناموفق بود ، لطفا با پشتیبانی تماس بگیرید یا مجددا سعی کنید!</p>
                                    </div>
                                    <div class="action d-sm-block d-grid gap-2">
                                        <a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>" class="btn border-0 rounded-pill main-color-two-bg">پرداخت مجدد</a>
                                        <?php if ( is_user_logged_in() ) : ?>
                                            <a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="btn border-0 rounded-pill main-color-one-bg">پنل کاربری</a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        <?php else : ?>

            <!-- Successful Transaction Message -->
            <div class="content">
                <div class="container-fluid">
                    <div class="payment-content mt-3 py-20">
                        <div class="row justify-content-center">
                            <div class="col-lg-6">
                                <div class="alert-box ab-success">
                                    <div class="title mt-3">
                                        <h5 class="h5 fw-900">پرداخت موفق!</h5>
                                    </div>
                                    <div class="desc">
                                        <p class="text-muted font-14">تشکر از شما کاربر گرامی پرداخت شما موفق بود ، محصول مورد نظر به زودی برای شما ارسال میشود</p>
                                    </div>
                                    <div class="action d-sm-block d-grid gap-2">
                                        <a href="<?php echo esc_url( home_url() ); ?>" class="btn border-0 rounded-pill main-color-three-bg">بازگشت به صفحه اصلی</a>
                                        <?php if ( is_user_logged_in() ) : ?>
                                            <a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="btn border-0 ms-2 rounded-pill main-color-one-bg">پنل کاربری</a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        <?php endif;

        do_action( 'woocommerce_thankyou_' . $order->get_payment_method(), $order->get_id() );
        do_action( 'woocommerce_thankyou', $order->get_id() );

    else : ?>

        <?php wc_get_template( 'checkout/order-received.php', array( 'order' => false ) ); ?>

    <?php endif; ?>

</div>

<?php
get_footer(); // Include site footer
?>
