<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action('woocommerce_before_single_product');

if (post_password_required()) {
    echo get_the_password_form(); // WPCS: XSS ok.
    return;
}
?>


<div class="content">
    <div class="container-fluid">
        <div class="content-box">
            <div class="row gy-3">
                <div class="col-lg-4">
                    <div class="amazing-timer" style="padding: 0 0 15px 0;">
                        <?php
                        $sale_end_timestamp = get_post_meta(get_the_ID(), '_sale_price_dates_to', true);
                        if ($sale_end_timestamp) {
                            $sale_end_date = date('Y-m-d', $sale_end_timestamp);
                            $sale_end_time = date('H:i', $sale_end_timestamp);
                            ?>
                            <div class="d-flex align-items-center flex-wrap">
                                <div class="d-grid gap-1">
                                    <span class="font-14">پیشنـهاد شگفت انگیـز
                                    </span>
                                    <span class="font-12 text-muted">فرصت باقی مانده</span>
                                </div>
                                <div class="flex-grow-1 text-end">
                                    <div class='countdown' data-date="<?php echo esc_attr($sale_end_date); ?>"
                                         data-time="<?php echo esc_attr($sale_end_time); ?>">
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                        ?>

                    </div>
                    <div class="pro_gallery">
                        <!--                        <div class="special-label">-->
                        <!--                            <img src="assets/image/SpecialSell.svg" alt="">-->
                        <!--                        </div>-->
                        <div class="icon-product-box">

                            <div class="icon-product-box-item hint--right share-item" data-bs-toggle="modal"
                                 data-bs-target="#shareModal" data-hint="اشتراک گذاری">
                                <i class="product-save bi bi-share-fill"></i>
                            </div>
                            <div class="icon-product-box-item hint--right" data-hint="افزودن به محصولات مورد علاقه">
                                <!--                                <i class="bi bi-heart"></i>-->
                                <?php echo favorite_krb(get_the_ID()); ?>
                            </div>
                            <div class="icon-product-box-item hint--right" data-hint="مقایسه محصول">
                                <!--                                <i class="bi bi-arrow-left-right"></i>-->
                                <?php
                                echo do_shortcode('[yith_compare_button product="' . get_the_ID() . '"]');
                                ?>
                            </div>
                        </div>
                        <div style="--swiper-navigation-color: #fff; --swiper-pagination-color: #fff"
                             class="swiper product-gallery">
                            <div class="swiper-wrapper" title="برای بزرگنمایی تصویر دابل کلیک کنید">
                                <?php
                                // بررسی اینکه آیا تصویر اصلی محصول موجود است
                                if (has_post_thumbnail()) :
                                    $product_thumbnail_id = get_post_thumbnail_id();
                                    $product_thumbnail_url = wp_get_attachment_url($product_thumbnail_id);
                                    $product_thumbnail_alt = get_post_meta($product_thumbnail_id, '_wp_attachment_image_alt', true); // دریافت alt
                                    ?>
                                    <div class="swiper-slide">
                                        <div class="swiper-zoom-container">
                                            <img class="img-fluid" src="<?php echo esc_url($product_thumbnail_url); ?>"
                                                 alt="<?php echo esc_attr($product_thumbnail_alt); ?>"/>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php
                                // دریافت گالری تصاویر محصول
                                $product_gallery_ids = get_post_meta(get_the_ID(), '_product_image_gallery', true);

                                if (!empty($product_gallery_ids)) :
                                    $gallery_ids = explode(',', $product_gallery_ids);

                                    foreach ($gallery_ids as $gallery_id) :
                                        $gallery_image_url = wp_get_attachment_url($gallery_id);
                                        $gallery_image_alt = get_post_meta($gallery_id, '_wp_attachment_image_alt', true); // دریافت alt برای گالری
                                        if ($gallery_image_url) :
                                            ?>
                                            <div class="swiper-slide">
                                                <div class="swiper-zoom-container">
                                                    <img class="img-fluid"
                                                         src="<?php echo esc_url($gallery_image_url); ?>"
                                                         alt="<?php echo esc_attr($gallery_image_alt); ?>"/>
                                                </div>
                                            </div>
                                        <?php
                                        endif;
                                    endforeach;
                                endif;
                                ?>

                            </div>
                            <div class="swiper-button-next d-none d-lg-flex"></div>
                            <div class="swiper-button-prev d-none d-lg-flex"></div>
                            <div class="swiper-pagination d-none d-lg-block"></div>
                        </div>
                        <div thumbsSlider="" class="swiper product-gallery-thumb">
                            <div class="swiper-wrapper">
                                <?php
                                // بررسی اینکه آیا تصویر اصلی محصول موجود است
                                if (has_post_thumbnail()) :
                                    $product_thumbnail_id = get_post_thumbnail_id();
                                    $product_thumbnail_url = wp_get_attachment_url($product_thumbnail_id);
                                    $product_thumbnail_alt = get_post_meta($product_thumbnail_id, '_wp_attachment_image_alt', true); // دریافت alt
                                    ?>
                                    <div class="swiper-slide">
                                        <div class="swiper-zoom-container">
                                            <img class="img-fluid" src="<?php echo esc_url($product_thumbnail_url); ?>"
                                                 alt="<?php echo esc_attr($product_thumbnail_alt); ?>"/>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php
                                // دریافت گالری تصاویر محصول
                                $product_gallery_ids = get_post_meta(get_the_ID(), '_product_image_gallery', true);

                                if (!empty($product_gallery_ids)) :
                                    $gallery_ids = explode(',', $product_gallery_ids);

                                    foreach ($gallery_ids as $gallery_id) :
                                        $gallery_image_url = wp_get_attachment_url($gallery_id);
                                        $gallery_image_alt = get_post_meta($gallery_id, '_wp_attachment_image_alt', true); // دریافت alt برای گالری
                                        if ($gallery_image_url) :
                                            ?>
                                            <div class="swiper-slide">
                                                <div class="swiper-zoom-container">
                                                    <img class="img-fluid"
                                                         src="<?php echo esc_url($gallery_image_url); ?>"
                                                         alt="<?php echo esc_attr($gallery_image_alt); ?>"/>
                                                </div>
                                            </div>
                                        <?php
                                        endif;
                                    endforeach;
                                endif;
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="product-meta">
                        <?php
                        $product_categories = get_the_terms(get_the_ID(), 'product_cat');
                        if (!empty($product_categories) && !is_wp_error($product_categories)) :
                            ?>
                            <nav aria-label="breadcrumb" class="mb-3">
                                <ol class="breadcrumb mb-0">
                                    <?php
                                    foreach ($product_categories as $category) :
                                        ?>
                                        <li class="breadcrumb-item active main-color-one-color font-16"
                                            aria-current="page">
                                            <?php echo esc_html($category->name); ?>
                                        </li>
                                    <?php
                                    endforeach;
                                    ?>
                                </ol>
                            </nav>
                        <?php
                        endif;
                        ?>

                        <div class="title mt-md-0 mt-3">
                            <h6 class="font-16 mb-2">
                                <?php echo get_the_title(); ?>
                            </h6>
                            <div class="d-flex align-items-center pb-2">
                                <div class="star">
                                    <?php
                                    // این کد برای صفحه single محصول در ووکامرس است
                                    if (is_product()) {
                                        global $product;

                                        // دریافت میانگین امتیاز محصول
                                        $average_rating = $product->get_average_rating();

                                        // تعداد ستاره‌های پر، نیمه پر و خالی را بر اساس میانگین امتیاز محاسبه کنید
                                        $full_stars = floor($average_rating); // ستاره‌های پر
                                        $half_star = ($average_rating - $full_stars) >= 0.5 ? 1 : 0; // ستاره نیمه پر
                                        $empty_stars = 5 - ($full_stars + $half_star); // ستاره‌های خالی

                                        // نمایش ستاره‌های پر
                                        for ($i = 1; $i <= $full_stars; $i++) {
                                            echo '<i class="bi bi-star-fill"></i>';
                                        }

                                        // نمایش ستاره نیمه پر در صورت نیاز
                                        if ($half_star) {
                                            echo '<i class="bi bi-star-half"></i>';
                                        }

                                        // نمایش ستاره‌های خالی
                                        for ($i = 1; $i <= $empty_stars; $i++) {
                                            echo '<i class="bi bi-star"></i>';
                                        }
                                    }
                                    ?>

                                </div>
                                <div class="ms-3">
                                    <?php
                                    if (is_product()) {
                                        global $product;
                                        $comments_count = $product->get_review_count();
                                        ?>
                                        <a class="main-color-one-color font-14">
                                            <span><?php echo $comments_count; ?></span>
                                            <span>دیدگاه</span>
                                        </a>
                                        <?php
                                    }
                                    ?>

                                </div>
                            </div>
                        </div>
                        <div class="product-feature py-2">
                            <nav class="navbar">
                                <?php
                                if (is_product()) {
                                    global $product;

                                    // دریافت ویژگی‌های محصول
                                    $product_attributes = $product->get_attributes();

                                    if (!empty($product_attributes)) :
                                        ?>
                                        <ul class="navbar-nav">
                                            <?php
                                            foreach ($product_attributes as $attribute_key => $attribute) :
                                                // نام ویژگی
                                                $attribute_name = wc_attribute_label($attribute->get_name());

                                                // بررسی اینکه آیا ویژگی "is_taxonomy" هست یا خیر
                                                if ($attribute->is_taxonomy()) {
                                                    // مقادیر ویژگی‌ها (به‌صورت اصطلاحات ووکامرس)
                                                    $attribute_values = wc_get_product_terms($product->get_id(), $attribute->get_name(), array('fields' => 'names'));
                                                    $attribute_values_string = implode(', ', $attribute_values); // تبدیل آرایه به رشته
                                                } else {
                                                    // برای ویژگی‌های سفارشی که taxonomy نیستند
                                                    $attribute_values_string = implode(', ', $attribute->get_options());
                                                }
                                                ?>
                                                <li class="nav-item pb-1 font-14">
                                                    <span class="nav-title me-1 fw-bold"><?php echo esc_html($attribute_name); ?>:</span>
                                                    <span class="nav-title-desc text-muted"><?php echo esc_html($attribute_values_string); ?></span>
                                                </li>
                                            <?php
                                            endforeach;
                                            ?>
                                        </ul>
                                    <?php
                                    endif;
                                }
                                ?>


                            </nav>
                        </div>
                        <div class="product-summary py-2">
                            <?php
                            if (get_theme_mod('productpage_display_summary_setting', true)) {
                                echo custom_product_excerpt(get_the_excerpt(), 50);
                            }
                            ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="se-cart">
                        <div class="se-cart-item pb-0">
                            <h4 class="font-18 fw-800 mb-4">
                                فروشگاه
                            </h4>
                        </div>
                        <?php
                        $sidebar_text = esc_html(get_theme_mod('productpage_sidebar_text_setting', 'گارانتی اصالت و سلامت فیزیکی کالا'));
                        if ($sidebar_text) { ?>
                            <div class="se-cart-item">
                                <i class="bi bi-shield-check me-1 font-20"></i>
                                <h6 class="d-inline font-16 fw-normal">
                                    <?php echo $sidebar_text; ?>
                                </h6>
                            </div>
                        <?php } ?>

                        <div class="se-cart-item">
                            <div class="d-flex">
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                         fill="currentColor" class="bi bi-shop" viewBox="0 0 16 16">
                                        <path
                                                d="M2.97 1.35A1 1 0 0 1 3.73 1h8.54a1 1 0 0 1 .76.35l2.609 3.044A1.5 1.5 0 0 1 16 5.37v.255a2.375 2.375 0 0 1-4.25 1.458A2.371 2.371 0 0 1 9.875 8 2.37 2.37 0 0 1 8 7.083 2.37 2.37 0 0 1 6.125 8a2.37 2.37 0 0 1-1.875-.917A2.375 2.375 0 0 1 0 5.625V5.37a1.5 1.5 0 0 1 .361-.976l2.61-3.045zm1.78 4.275a1.375 1.375 0 0 0 2.75 0 .5.5 0 0 1 1 0 1.375 1.375 0 0 0 2.75 0 .5.5 0 0 1 1 0 1.375 1.375 0 1 0 2.75 0V5.37a.5.5 0 0 0-.12-.325L12.27 2H3.73L1.12 5.045A.5.5 0 0 0 1 5.37v.255a1.375 1.375 0 0 0 2.75 0 .5.5 0 0 1 1 0zM1.5 8.5A.5.5 0 0 1 2 9v6h1v-5a1 1 0 0 1 1-1h3a1 1 0 0 1 1 1v5h6V9a.5.5 0 0 1 1 0v6h.5a.5.5 0 0 1 0 1H.5a.5.5 0 0 1 0-1H1V9a.5.5 0 0 1 .5-.5zM4 15h3v-5H4v5zm5-5a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1h-2a1 1 0 0 1-1-1v-3zm3 0h-2v3h2v-3z">
                                        </path>
                                    </svg>
                                </div>
                                <div class="text-start ms-3">
                                    <h6 class="fw-normal font-16">
                                        وضعیت :
                                        <?php
                                        $stock = stack_status(get_the_ID());
                                        if ($stock['status']) { ?>
                                            <span>
                                            موجود در انبار
                                        </span>
                                        <?php } else { ?>
                                            <span style="color: red">
                                            ناموجود
                                            </span>
                                        <?php } ?>
                                    </h6>
                                </div>
                            </div>
                        </div>
                        <div class="se-cart-item d-lg-flex justify-content-between align-items-center">
                            <div>
                                <i class="bi bi-info-circle font-18 me-2"></i>
                                <span class="font-12">
                                        قیمت فروشنده
                                    </span>
                            </div>
                            <div class="price d-flex flex-column justify-content-end">
                                <p class="<?php echo esc_attr(apply_filters('woocommerce_product_price_class', 'price')); ?>"><?php echo $product->get_price_html(); ?></p>
                            </div>
                        </div>
                        <div class="se-cart-item d-inline-flex">
                            <i class="bi bi-cart-plus"></i>
                            <?php
                            do_action('woocommerce_' . $product->get_type() . '_add_to_cart');
                            ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<!-- end meta product -->


<!-- start product desc -->
<div class="content">
    <div class="container-fluid">
        <div class="content-box">
            <div class="product-descs" id="prodesc">
                <div class="product-desc">
                    <div class="product-desc-tab">
                        <ul class="nav" id="productTab" role="tablist">
                            <li class="nav-item">
                                <button class="active waves-effect waves-light" id="productDescLess"
                                        data-bs-toggle="tab" data-bs-target="#productDescLess-pane" role="tab"
                                        type="button" aria-selected="true"><i class="bi bi-file-richtext"></i> معرفی
                                </button>
                            </li>
                            <li class="nav-item">
                                <button class=" waves-effect waves-light" id="productDesc" data-bs-toggle="tab"
                                        data-bs-target="#productDesc-pane" role="tab" type="button"
                                        aria-selected="true"><i class="bi bi-file-text"></i>
                                    توضیحات
                                </button>
                            </li>
                            <li class="nav-item">
                                <button class=" waves-effect waves-light" id="productComment" data-bs-toggle="tab"
                                        data-bs-target="#productComment-pane" role="tab" type="button"
                                        aria-selected="false"><i class="bi bi-chat-quote"></i>
                                    نظرات (<?php echo $post->comment_count; ?>)
                                </button>
                            </li>
                        </ul>
                    </div>
                    <div class="product-desc-tab-content">
                        <div class="tab-content" id="productTabContent">
                            <div class="tab-pane fade show active product-desc-less-contents"
                                 id="productDescLess-pane">
                                <div class="product-desc-content">
                                    <input type="checkbox" class="read-more-state" id="readMore3"/>
                                    <!-- والد بیشتر ، کمتر ، تمام متن توضیحات باید داخل این تگ قرار بگیرند -->
                                    <div class="read-more-wrap">
                                        <h2 class="title gold mb-2">مشخصات محصول</h2>
                                        <?php echo do_shortcode("[product_additional_information]"); ?>
                                    </div>
                                </div>
                            </div>



                            <div class="tab-pane fade product-desc-contents" id="productDesc-pane">
                                <div class="product-desc-content">
                                    <input type="checkbox" class="read-more-state" id="readMore2" />
                                    <div class="read-more-wrap">
                                        <h2 class="title gold mb-2">
                                            توضیحات محصول
                                        </h2>
                                        <?php
                                        if (is_product()) {
                                            global $product;

                                            // دریافت توضیحات محصول
                                            $full_description = wp_kses_post($product->get_description());

                                            if (!empty($full_description)) {

                                                // تبدیل توضیحات به آرایه کلمات
                                                $words = explode(' ', wp_strip_all_tags($full_description));

                                                // 50 کلمه اول
                                                $first_50_words = array_slice($words, 0, 50);

                                                // ادامه متن بعد از 50 کلمه
                                                $remaining_words = array_slice($words, 50);

                                                // نمایش خلاصه
                                                echo '<div class="read-more-summary">';
                                                echo implode(' ', $first_50_words) . '...';
                                                echo '</div>';

                                                // نمایش بخش کامل
                                                echo '<div class="read-more-full">';
                                                echo implode(' ', $remaining_words);
                                                echo '</div>';

                                            } else {
                                                echo '<p>توضیحات در دسترس نیست.</p>';
                                            }
                                        }
                                        ?>

                                    </div>
                                    <label for="readMore2" class="read-more-trigger"></label>
                                </div>
                            </div>







                            <div class="tab-pane fade product-comment-content" id="productComment-pane">
                                <div class="row">
                                    <?php
                                    if (comments_open() || get_comments_number()) :
                                        comments_template();
                                    endif;
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- end product desc -->


<div class="product-box py-20">
    <div class="container-fluid">
        <div class="parent">
            <div class="content-title">
                <div class="item">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                         class="bi bi-box-seam" viewBox="0 0 16 16">
                        <path
                                d="M8.186 1.113a.5.5 0 0 0-.372 0L1.846 3.5l2.404.961L10.404 2l-2.218-.887zm3.564 1.426L5.596 5 8 5.961 14.154 3.5l-2.404-.961zm3.25 1.7-6.5 2.6v7.922l6.5-2.6V4.24zM7.5 14.762V6.838L1 4.239v7.923l6.5 2.6zM7.443.184a1.5 1.5 0 0 1 1.114 0l7.129 2.852A.5.5 0 0 1 16 3.5v8.662a1 1 0 0 1-.629.928l-7.185 2.874a.5.5 0 0 1-.372 0L.63 13.09a1 1 0 0 1-.63-.928V3.5a.5.5 0 0 1 .314-.464L7.443.184z"/>
                    </svg>
                    <h5 class="title">محصولات مرتبط</h5>
                </div>
                <div class="item">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"
                         class="bi bi-box-arrow-in-left" viewBox="0 0 16 16">
                        <path fill-rule="evenodd"
                              d="M10 3.5a.5.5 0 0 0-.5-.5h-8a.5.5 0 0 0-.5.5v9a.5.5 0 0 0 .5.5h8a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 1 1 0v2A1.5 1.5 0 0 1 9.5 14h-8A1.5 1.5 0 0 1 0 12.5v-9A1.5 1.5 0 0 1 1.5 2h8A1.5 1.5 0 0 1 11 3.5v2a.5.5 0 0 1-1 0v-2z"/>
                        <path fill-rule="evenodd"
                              d="M4.146 8.354a.5.5 0 0 1 0-.708l3-3a.5.5 0 1 1 .708.708L5.707 7.5H14.5a.5.5 0 0 1 0 1H5.707l2.147 2.146a.5.5 0 0 1-.708.708l-3-3z"/>
                    </svg>
                    <a href="">
                        <h5 class="title">مشاهده همه</h5>
                    </a>
                </div>
            </div>
            <div class="swiper free-mode" id="product-box">
                <div class="swiper-wrapper">
                    <?php
                    $related = wc_get_related_products(get_the_ID(), 10);
                    if ($related) {
                        foreach ($related as $post) {
                            setup_postdata($post);
                            ?>
                            <div class="swiper-slide">
                                <?php
                                productBox2($post, false);  ?>
                            </div>
                            <?php
                            wp_reset_postdata();
                        }
                    }
                    ?>
                </div>
                <div class="swiper-pagination"></div>
                <div class="swiper-button-next d-sm-flex d-none"></div>
                <div class="swiper-button-prev d-sm-flex d-none"></div>
            </div>
        </div>
    </div>
</div>
<!-- end product box -->



<!-- modal shahre -->
<div class="share-modal">
    <div class="modal fade" id="shareModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title" id="exampleModalLabel">اشتراک گذاری</h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <h4 class="font-18 my-3">این کالا را با دوستان خود به اشتراک بگذارید!</h4>
                    <!--                    <button class="btn d-block border text-center w-100" onclick="copyToClipboard()">-->
                    <!--                        <i class="bi bi-clipboard2-plus me-1"></i> کپی کردن لینک-->
                    <!--                    </button>-->
                    <div class="row mt-3 gy-3">
                        <?php $product_link = get_permalink(); ?>
                        <!-- WhatsApp Share Link -->
                        <div class="col-6">
                            <a href="https://wa.me/?text=<?php echo urlencode($product_link); ?>" target="_blank" class="btn main-color-three-bg p-4 d-block w-100">
                                <i class="bi bi-whatsapp me-2 font-20"></i>
                                <span>واتس آپ</span>
                            </a>
                        </div>
                        <!-- Twitter Share Link -->
                        <div class="col-6">
                            <a href="https://twitter.com/intent/tweet?url=<?php echo urlencode($product_link); ?>" target="_blank" class="btn main-color-one-bg p-4 d-block w-100" style="background-color: #111111 !important;">
                                <i class="bi bi-twitter me-2 font-20"></i>
                                <span>توییتر</span>
                            </a>
                        </div>
                        <!-- Facebook Share Link -->
                        <div class="col-6">
                            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode($product_link); ?>" target="_blank" class="btn main-color-one-bg p-4 d-block w-100" style="background-color: #005393 !important;">
                                <i class="bi bi-facebook me-2 font-20"></i>
                                <span>فیسبوک</span>
                            </a>
                        </div>
                        <!-- Telegram Share Link -->
                        <div class="col-6">
                            <a href="https://t.me/share/url?url=<?php echo urlencode($product_link); ?>" target="_blank" class="btn main-color-three-bg p-4 d-block w-100" style="background-color: #0088cc !important;">
                                <i class="bi bi-telegram me-2 font-20"></i>
                                <span>تلگرام</span>
                            </a>
                        </div>

                        <!-- LinkedIn Share Link -->
                        <div class="col-6">
                            <a href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo urlencode($product_link); ?>" target="_blank" class="btn main-color-one-bg p-4 d-block w-100" style="background-color: #0e76e8 !important;">
                                <i class="bi bi-linkedin me-2 font-20"></i>
                                <span>لینکدین</span>
                            </a>
                        </div>

                        <!-- Email Share Link -->
                        <div class="col-6">
                            <a href="mailto:?subject=Check%20this%20out&body=<?php echo urlencode($product_link); ?>" target="_blank" class="btn main-color-two-bg p-4 d-block w-100" >
                                <i class="bi bi-envelope me-2 font-20"></i>
                                <span>ایمیل</span>
                            </a>
                        </div>
                    </div>
                    <!--                    <div class="row mt-3 gy-2 align-items-center">-->
                    <!--                        <div class="col-6">-->
                    <!--                            <img src="--><?php //echo Cama_PLG_URI ?><!-- /assets/image/mobile.png" class="img-fluid d-block ms-auto" alt="لینک صفحه محصول">-->
                    <!--                        </div>-->
                    <!--                    </div>-->
                </div>
            </div>
        </div>
    </div>
</div>



<!--end modal share-->



<?php do_action('woocommerce_after_single_product'); ?>

