<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$allowed_html = array(
	'a' => array(
		'href' => array(),
	),
);
?>
    <section class="section">

        <ul class="breadcrumb breadcrumb-style ">
            <?php woocommerce_breadcrumb(); ?>
        </ul>
        <div class="row">

            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-statistic-4">
                        <div class="info-box7-block">
                            <h6 class="m-b-20 text-right">مدت عضویت شما</h6>
                            <h4 class="text-right">
                                <i class="pull-left bg-indigo c-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                         viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                         stroke-linecap="round" stroke-linejoin="round"
                                         class="feather feather-monitor">
                                        <rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect>
                                        <line x1="8" y1="21" x2="16" y2="21"></line>
                                        <line x1="12" y1="17" x2="12" y2="21"></line>
                                    </svg>
                                </i>
                                <span>
                                    <?php
                                    echo human_time_diff(strtotime(get_userdata(get_current_user_id())->user_registered));
                                    ?>
                                </span>
                            </h4>
                            <p class="mb-0 mt-3 text-muted">
                                <i class="far fa-thumbs-up col-green m-r-5"></i>
                                <span class="text-success font-weight-bold">    ثبت نام موفقیت آمیز</span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-statistic-4">
                        <div class="info-box7-block">
                            <h6 class="m-b-20 text-right">خریدهای شما</h6>
                            <h4 class="text-right">
                                <i class=" pull-left bg-cyan c-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                         viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                         stroke-linecap="round" stroke-linejoin="round"
                                         class="feather feather-image">
                                        <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
                                        <circle cx="8.5" cy="8.5" r="1.5"></circle>
                                        <polyline points="21 15 16 10 5 21"></polyline>
                                    </svg>
                                </i>
                                <span>
                                    <?php
                                    // GET USER ORDERS (COMPLETED + PROCESSING)
                                    $customer_orders = get_posts(array(
                                        'numberposts' => -1,
                                        'meta_key' => '_customer_user',
                                        'meta_value' => $current_user->ID,
                                        'post_type' => wc_get_order_types(),
                                        'post_status' => array('wc-completed'),
                                    ));
                                    // LOOP THROUGH ORDERS AND GET PRODUCT IDS
                                    $product_ids = array();
                                    foreach ($customer_orders as $customer_order) {
                                        $order = new WC_Order($customer_order->ID);
                                        $items = $order->get_items();
                                        foreach ($items as $item) {
                                            $product_id = $item->get_product_id();
                                            $product_ids[] = $product_id;
                                        }
                                    }
                                    $product_ids = array_unique($product_ids);

                                    // QUERY PRODUCTS
                                    $args = array(
                                        'post_type' => 'product',
                                        'post__in' => $product_ids,
                                    );

                                    echo count($product_ids);
                                    ?>
                                </span>
                            </h4>
                            <p class="mb-0 mt-3 text-muted"><i class="far fa-handshake col-green m-r-5">
                                </i><span class="text-success font-weight-bold">دوره ثبت نام کرده اید</span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-statistic-4">
                        <div class="info-box7-block">
                            <h6 class="m-b-20 text-right">محصولات</h6>
                            <h4 class="text-right">
                                <i class=" pull-left bg-deep-orange c-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                         viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                         stroke-linecap="round" stroke-linejoin="round"
                                         class="feather feather-shopping-bag">
                                        <path d="M6 2L3 6v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V6l-3-4z"></path>
                                        <line x1="3" y1="6" x2="21" y2="6"></line>
                                        <path d="M16 10a4 4 0 0 1-8 0"></path>
                                    </svg>
                                </i>
                                <span><?php echo WC()->cart->get_cart_contents_count(); ?></span>
                            </h4>
                            <p class="mb-0 mt-3 text-muted">
                                <i class="fas fa-arrow-circle-up col-red m-r-5"></i>
                                <span class="col-red font-weight-bold">در انتظار پرداخت</span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-statistic-4">
                        <div class="info-box7-block">
                            <h6 class="m-b-20 text-right">خرید های</h6>
                            <?php
                            $wwh_user_id = get_current_user_id();
                            $wwh_upat = wc_get_customer_total_spent($wwh_user_id);
                            $wwh_upat = substr($wwh_upat, 0, strpos($wwh_upat, "."));
                            if ($wwh_upat != 0) { ?>
                                <h4 class="text-right">
                                    <i class="fas fa-dollar-sign pull-left bg-green c-icon"></i> <?php echo $wwh_upat;
                                    echo get_woocommerce_currency_symbol(); ?>
                                </h4>


                                <?php
                            } else {
                                ?>
                                <h4 class="text-right">
                                    <i class="fas fa-dollar-sign pull-left bg-green c-icon"></i><span>شما هیچ سفارشی نداشته اید</span>
                                </h4>
                                <?php
                            }
                            ?>
                            <p class="mb-0 mt-3 text-muted"><i
                                        class="fas fa-arrow-circle-down col-green m-r-5"></i><span
                                        class="col-green font-weight-bold">مجموعه خریدهای شما</span></p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-statistic-4">
                        <div class="info-box7-block">
                            <h6 class="m-b-20 text-right"> محصولات موجود در سایت</h6>
                            <h4 class="text-right"><i class=" pull-left bg-blue c-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                         viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                         stroke-linecap="round" stroke-linejoin="round"
                                         class="feather feather-shopping-bag">
                                        <path d="M6 2L3 6v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V6l-3-4z"></path>
                                        <line x1="3" y1="6" x2="21" y2="6"></line>
                                        <path d="M16 10a4 4 0 0 1-8 0"></path>
                                    </svg>
                                </i><span><?php
                                    function product_count_shortcode()
                                    {
                                        $count_posts = wp_count_posts('product');
                                        return $count_posts->publish;
                                    }

                                    add_shortcode('product_count', 'product_count_shortcode');
                                    echo do_shortcode('[product_count]');
                                    ?>   </span></h4>

                            <p class="mb-0 mt-3 text-muted">
                                <i class="fas fa-arrow-circle-down col-green m-r-5">
                                </i>
                                <span class="col-green font-weight-bold"> تعداد کامل محصولات سایت</span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-statistic-4">
                        <div class="info-box7-block">
                            <h6 class="m-b-20 text-right"> نظرات شما</h6>
                            <h4 class="text-right"><i class=" pull-left bg-danger c-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                         viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                         stroke-linecap="round" stroke-linejoin="round"
                                         class="feather feather-user-check">
                                        <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                                        <circle cx="8.5" cy="7" r="4"></circle>
                                        <polyline points="17 11 19 13 23 9"></polyline>
                                    </svg>
                                </i>
                                <span><?php
                                    global $wpdb, $post, $current_user;
                                    wp_get_current_user();
                                    $userId = $current_user->ID;
                                    $where = 'WHERE comment_approved = 1 AND user_id = ' . $userId;
                                    $comment_count = $wpdb->get_var("SELECT COUNT( * ) AS total FROM {$wpdb->comments}
                                 {$where}");
                                    echo $comment_count;
                                    ?> </span>
                            </h4>

                            <p class="mb-0 mt-3 text-muted">
                                <i class="fas fa-comment col-green m-r-5"></i>
                                <span class="col-green font-weight-bold">تعداد نظرات ارسال شده توسط شما</span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <div class="row">

            <div class="col-12 col-sm-12 col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4>آخرین مطالب وبلاک</h4>
                    </div>
                    <?php
                    ?>
                    <div class="card-body">
                        <div id="activity-scroll">
                            <ul class="activity-list">
                                <?php
                                $args = array('post_type'=>'post','posts_per_page'=>12);
                                $wp_qurey = new WP_Query($args);
                                if ($wp_qurey->have_posts()):
                                    ?>
                                    <?php while ($wp_qurey->have_posts()): $wp_qurey->the_post();?>

                                    <li><i class="activity-icon bg-success"></i>
                                        <a href="<?php the_permalink(); ?>" target="_blank">
                                            <h6> <?php the_title()?>
                                                <small class="float-right text-muted">
                                                    <?php
                                                    $post_date = get_the_date('I f j,Y');echo $post_date;
                                                    ?>
                                                </small>
                                            </h6>
                                        </a>
                                        <span class="font-12">
                                    <?php the_excerpt();?>
                                    </span>
                                    </li>

                                <?php endwhile;
                                    wp_reset_postdata();
                                endif;?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12 col-sm-12 col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4>آخرین محصولات سایت </h4>
                    </div>

                    <div class="card-body">
                        <div class="media-list position-relative">
                            <div class="table-responsive" id="project-team-scroll">
                                <table class="table table-hover table-xl mb-0">
                                    <thead>
                                    <?php
                                    $args1 = array('post_type'=>'product','posts_per_page'=>12);
                                    $wp_qurey1 = new WP_Query($args1);
                                    if ($wp_qurey1->have_posts()):
                                        ?>
                                        <?php while ($wp_qurey1->have_posts()):$wp_qurey1->the_post();?>
                                        <tr>
                                            <td class="text-truncate">
                                                <a href="<?php the_permalink(); ?>" target="_blank"  title="<?php the_title() ?>" data-original-title="<?php the_title()?>">
                                                    <?php echo get_the_title(); ?>
                                                </a>
                                            </td>
                                            <td class="text-truncate">
                                                <ul class="list-unstyled order-list m-b-0 m-b-0">
                                                    <li class="team-member team-member-sm">
                                                        <?php if (has_post_thumbnail($post->ID)):?>
                                                            <?php $image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID),'mainpost')?>
                                                            <img class="rounded-circle" src="<?php echo $image[0];?>" alt="<?php the_title()?>" data-toggle="tooltip" title="<?php the_title()?>" data-original-title="<?php the_title()?>">
                                                        <?php endif;?>
                                                    </li>
                                                </ul>
                                            </td>
                                            <td class="text-truncate">
                                                <?php woocommerce_template_loop_price();?>
                                            </td>
                                        </tr>

                                    <?php endwhile;
                                        wp_reset_postdata();
                                    endif;?>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>
<?php
	/**
	 * My Account dashboard.
	 *
	 * @since 2.6.0
	 */
	do_action( 'woocommerce_account_dashboard' );

	/**
	 * Deprecated woocommerce_before_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_before_my_account' );

	/**
	 * Deprecated woocommerce_after_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_after_my_account' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
