<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );
exit(3333);
/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action( 'woocommerce_before_main_content' );

?>
<!-- Shop Category Area End -->
            <div class="shop-category-area mt-30px">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12 col-md-12">
                            <!-- Shop Top Area Start -->
                            <div class="shop-top-bar d-flex">
                                <header class="woocommerce-products-header">
                                    <?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
                                        <h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>
                                    <?php endif; ?>

                                    <?php
                                    /**
                                     * Hook: woocommerce_archive_description.
                                     *
                                     * @hooked woocommerce_taxonomy_archive_description - 10
                                     * @hooked woocommerce_product_archive_description - 10
                                     */
                                    do_action( 'woocommerce_archive_description' );
                                    ?>
                                </header>
                            </div>
                            <!-- Shop Top Area End -->

                            <!-- Shop Bottom Area Start -->
                            <div class="shop-bottom-area mt-35">
                                <!-- Shop Tab Content Start -->
                                <div class="tab-content jump">
                                    <!-- Tab One Start -->
                                    <div id="shop-1" class="tab-pane">
                                        <div class="row responsive-md-class">
                                            <?php
                                            if ( woocommerce_product_loop() ) {

                                                /**
                                                 * Hook: woocommerce_before_shop_loop.
                                                 *
                                                 * @hooked woocommerce_output_all_notices - 10
                                                 * @hooked woocommerce_result_count - 20
                                                 * @hooked woocommerce_catalog_ordering - 30
                                                 */
                                                do_action( 'woocommerce_before_shop_loop' );

                                                woocommerce_product_loop_start();

                                                if ( wc_get_loop_prop( 'total' ) ) {
                                                    while ( have_posts() ) {
                                                        the_post();
                                                        ?>
                                                        <div class="col-xl-3 col-md-4 col-sm-6 ">
                                                            <article class="list-product">
                                                                <div class="img-block">
                                                                    <?php if (has_post_thumbnail(get_the_ID())) { ?>
                                                                                <a href="<?php the_permalink(); ?>" class="thumbnail">
                                                                                    <img class="first-img" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="" />
                                                                                    <img class="second-img" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="" />
                                                                                </a>
                                                                    <?php }else{ ?>
                                                                        <a href="<?php the_permalink(); ?>" class="thumbnail">
                                                                            <img class="first-img" src="<?php echo Sabat_PLG_URI . 'assets/images/product-image/9.jpg'  ?>" alt="" />
                                                                            <img class="second-img" src="<?php echo Sabat_PLG_URI . 'assets/images/product-image/9.jpg'  ?>" alt="" />
                                                                        </a>
                                                                    <?php } ?>
<!--                                                                    <div class="quick-view">-->
<!--                                                                        <a class="quick_view" href="#" data-link-action="quickview" title="مشاهده سریع" data-bs-toggle="modal" data-bs-target="#exampleModal">-->
<!--                                                                            <i class="ion-ios-search-strong"></i>-->
<!--                                                                        </a>-->
<!--                                                                    </div>-->
                                                                </div>
                                                                <ul class="product-flag">
                                                                    <li class="new">جدید</li>
                                                                </ul>
                                                                <div class="product-decs">
                                                                    <a class="inner-link" href="<?php the_permalink(); ?>"><span><?php echo the_title(); ?></span></a>
                                                                    <h2><a href="<?php the_permalink(); ?>" class="product-link"><?php echo get_the_excerpt(); ?></a></h2>
<!--                                                                    <div class="rating-product">-->
<!--                                                                        <i class="ion-android-star"></i>-->
<!--                                                                        <i class="ion-android-star"></i>-->
<!--                                                                        <i class="ion-android-star"></i>-->
<!--                                                                        <i class="ion-android-star"></i>-->
<!--                                                                        <i class="ion-android-star"></i>-->
<!--                                                                    </div>-->
                                                                    <div class="pricing-meta">
                                                                        <?php
                                                                        $id = get_the_ID();
                                                                        $product = wc_get_product($id);
                                                                        $price = price_product($id);
                                                                        if ($price['sale']){
                                                                            ?>
                                                                            <ul>
                                                                                <li class="old-price"><?php echo $price['regular']; ?></li>
                                                                                <li class="current-price"><?php echo $price['sale']; echo get_woocommerce_currency_symbol(); ?></li>
                                                                                <li class="discount-price"><?php echo $price['percentage']; ?></li>
                                                                            </ul>
                                                                        <?php }else{ ?>
                                                                            <ul>
                                                                                <li class="current-price"><?php echo $price['regular']; echo get_woocommerce_currency_symbol(); ?></li>
                                                                            </ul>
                                                                        <?php } ?>
                                                                    </div>
                                                                </div>
                                                                <div class="add-to-link">
                                                                    <ul>
                                                                        <li class="cart"><a class="cart-btn" href="#">خرید</a></li>
                                                                        <li>
                                                                            <a href="wishlist.html"><i class="icon-heart"></i></a>
                                                                        </li>
                                                                        <li>
                                                                            <a href="compare.html"><i class="icon-shuffle"></i></a>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                            </article>
                                                        </div>
                                                     <?php
                                                    }
                                                }

                                                woocommerce_product_loop_end();

                                                /**
                                                 * Hook: woocommerce_after_shop_loop.
                                                 *
                                                 * @hooked woocommerce_pagination - 10
                                                 */
                                                do_action( 'woocommerce_after_shop_loop' );
                                            } else {
                                            /**
                                            * Hook: woocommerce_no_products_found.
                                            *
                                            * @hooked wc_no_products_found - 10
                                            */
                                            do_action( 'woocommerce_no_products_found' );
                                            }
                                            ?>
                                        </div>
                                    </div>
                                    <!-- Tab One End -->
                                    <!-- Tab Two Start -->
                                    <div id="shop-2" class="tab-pane active">
                                        <div class="shop-list-wrap mb-30px scroll-zoom">
                                            <div class="row list-product m-0px">
                                                <div class="col-md-12 padding-0px">
                                                    <div class="row">
                                                        <?php
                                                        if ( woocommerce_product_loop() ) {

                                                        /**
                                                         * Hook: woocommerce_before_shop_loop.
                                                         *
                                                         * @hooked woocommerce_output_all_notices - 10
                                                         * @hooked woocommerce_result_count - 20
                                                         * @hooked woocommerce_catalog_ordering - 30
                                                         */
                                                        do_action( 'woocommerce_before_shop_loop' );

                                                        woocommerce_product_loop_start();

                                                        if ( wc_get_loop_prop( 'total' ) ) {
                                                        while ( have_posts() ) {
                                                        the_post();
                                                        ?>
                                                        <div class="col-xs-12 col-sm-12 col-md-4 col-lg-3">
                                                            <div class="left-img">
                                                                <div class="img-block">
                                                                    <?php if (has_post_thumbnail(get_the_ID())) { ?>
                                                                        <a href="<?php the_permalink(); ?>" class="thumbnail">
                                                                            <img class="first-img" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="" />
                                                                            <img class="second-img" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="" />
                                                                        </a>
                                                                    <?php }else{ ?>
                                                                        <a href="<?php the_permalink(); ?>" class="thumbnail">
                                                                            <img class="first-img" src="<?php echo Sabat_PLG_URI . 'assets/images/product-image/9.jpg'  ?>" alt="" />
                                                                            <img class="second-img" src="<?php echo Sabat_PLG_URI . 'assets/images/product-image/9.jpg'  ?>" alt="" />
                                                                        </a>
                                                                    <?php } ?>
<!--                                                                    <div class="quick-view">-->
<!--                                                                        <a class="quick_view" href="#" data-link-action="quickview" title="مشاهده سریع" data-bs-toggle="modal" data-bs-target="#exampleModal">-->
<!--                                                                            <i class="ion-ios-search-strong"></i>-->
<!--                                                                        </a>-->
<!--                                                                    </div>-->
                                                                </div>
                                                                <ul class="product-flag">
                                                                    <li class="new">جدید</li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                        <div class="col-xs-12 col-sm-12 col-md-8 col-lg-9">
                                                            <div class="product-desc-wrap">
                                                                <div class="product-decs">
                                                                    <a class="inner-link" href="<?php the_permalink(); ?>"><span><?php echo the_title(); ?></span></a>
<!--                                                                    <h2><a href="single-product.html" class="product-link">جزئیات مربوط به محصول فروشگاه</a></h2>-->
<!--                                                                    <div class="rating-product">-->
<!--                                                                        <i class="ion-android-star"></i>-->
<!--                                                                        <i class="ion-android-star"></i>-->
<!--                                                                        <i class="ion-android-star"></i>-->
<!--                                                                        <i class="ion-android-star"></i>-->
<!--                                                                        <i class="ion-android-star"></i>-->
<!--                                                                    </div>-->
                                                                     <div class="product-intro-info">
                                                                        <p><?php echo get_the_excerpt(); ?></p>
                                                                    </div>
                                                                </div>
                                                                <div class="box-inner">
                                                                    <div class="in-stock"> وضعیت : <span><?php stack_status($id); ?></span></div>
                                                                    <div class="pricing-meta">
                                                                        <?php
                                                                        $id = get_the_ID();
                                                                        $product = wc_get_product($id);
                                                                        $price = price_product($id);
                                                                        if ($price['sale']){
                                                                            ?>
                                                                            <ul>
                                                                                <li class="old-price"><?php echo $price['regular']; ?></li>
                                                                                <li class="current-price"><?php echo $price['sale']; echo get_woocommerce_currency_symbol(); ?></li>
                                                                                <li class="discount-price"><?php echo $price['percentage']; ?></li>
                                                                            </ul>
                                                                        <?php }else{ ?>
                                                                            <ul>
                                                                                <li class="current-price"><?php echo $price['regular']; echo get_woocommerce_currency_symbol(); ?></li>
                                                                            </ul>
                                                                        <?php } ?>
                                                                    </div>
                                                                    <div class="add-to-link">
                                                                        <ul>
                                                                            <li class="cart"><a title="افزودن به سبد خرید" class="cart-btn" href="#">افزودن به سبد خرید </a></li>
                                                                            <li>
                                                                                <a href="wishlist.html" title="افزودن به لیست علاقه مندی ها"><i class="icon-heart"></i> افزودن به لیست علاقه مندی ها</a>
                                                                            </li>
                                                                            <li>
                                                                                <a href="compare.html" title="مقایسه محصول"><i class="icon-shuffle"></i> مقایسه محصول</a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                            <?php
                                                        }
                                                        }

                                                            woocommerce_product_loop_end();

                                                            /**
                                                             * Hook: woocommerce_after_shop_loop.
                                                             *
                                                             * @hooked woocommerce_pagination - 10
                                                             */
                                                            do_action( 'woocommerce_after_shop_loop' );
                                                        } else {
                                                            /**
                                                             * Hook: woocommerce_no_products_found.
                                                             *
                                                             * @hooked wc_no_products_found - 10
                                                             */
                                                            do_action( 'woocommerce_no_products_found' );
                                                        }
                                                        ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab Two End -->
                                </div>
                                <!-- Shop Tab Content End -->
                                <!--  Pagination Area Start -->
                                <div class="pro-pagination-style text-center">
                                    <?php
                                    echo get_the_posts_pagination();
                                    ?>
                                </div>
                                <!--  Pagination Area End -->
                            </div>
                            <!-- Shop Bottom Area End -->
                        </div>
                    </div>
                </div>
            </div>
            <!-- Shop Category Area End -->